/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.system.jdbc.JdbcControl;
import org.apache.beehive.controls.system.jdbc.ResultSetMapper;
import org.apache.beehive.controls.system.jdbc.RowMapper;
import org.apache.beehive.controls.system.jdbc.RowMapperFactory;
import org.apache.beehive.controls.system.jdbc.TypeMappingsFactory;

public class DefaultObjectResultSetMapper
extends ResultSetMapper {
    protected static final TypeMappingsFactory _tmf = TypeMappingsFactory.getInstance();

    public Object mapToResultType(ControlBeanContext context, Method m, ResultSet resultSet, Calendar cal) {
        Class<?> returnType = m.getReturnType();
        boolean isArray = returnType.isArray();
        try {
            if (isArray) {
                JdbcControl.SQL methodSQL = (JdbcControl.SQL)context.getMethodPropertySet(m, JdbcControl.SQL.class);
                return this.arrayFromResultSet(resultSet, methodSQL.arrayMaxLength(), returnType, cal);
            }
            if (!resultSet.next()) {
                return _tmf.fixNull(m.getReturnType());
            }
            return RowMapperFactory.getRowMapper(resultSet, returnType, cal).mapRowToReturnType();
        }
        catch (SQLException e) {
            throw new ControlException(e.getMessage(), (Throwable)e);
        }
    }

    protected Object arrayFromResultSet(ResultSet rs, int maxRows, Class arrayClass, Calendar cal) throws SQLException {
        int numRows;
        Class<?> componentType = arrayClass.getComponentType();
        ResultSetMetaData md = rs.getMetaData();
        ArrayList<Object> list = new ArrayList<Object>();
        boolean hasMoreRows = rs.next();
        RowMapper rowMapper = RowMapperFactory.getRowMapper(rs, componentType, cal);
        for (numRows = 0; numRows != maxRows && hasMoreRows; ++numRows) {
            list.add(rowMapper.mapRowToReturnType());
            hasMoreRows = rs.next();
        }
        Object array = Array.newInstance(componentType, numRows);
        try {
            for (int i = 0; i < numRows; ++i) {
                Array.set(array, i, list.get(i));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ControlException("The declared Java type for array " + componentType.getName() + "is incompatible with the SQL format of column " + md.getColumnName(1) + md.getColumnTypeName(1) + "which returns objects of type + " + list.get(0).getClass().getName());
        }
        return array;
    }
}

