/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.runners.samza.translation.SamzaImpulseSystemFactory;
import org.apache.samza.Partition;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.WatermarkMessage;
import org.junit.Assert;
import org.junit.Test;

public class SamzaImpulseSystemTest {
    @Test
    public void testSamzaImpulseSystemConsumer() throws Exception {
        SystemConsumer consumer = new SamzaImpulseSystemFactory().getConsumer("default-system", (Config)new MapConfig(), null);
        Map result = consumer.poll(Collections.singleton(this.sspForPartition(0)), 100L);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.containsKey(this.sspForPartition(0)));
        List messageEnvelopes = (List)result.get(this.sspForPartition(0));
        Assert.assertEquals((long)3L, (long)messageEnvelopes.size());
        Assert.assertTrue((boolean)(((IncomingMessageEnvelope)messageEnvelopes.get(0)).getMessage() instanceof OpMessage));
        OpMessage impulseEvent = (OpMessage)((IncomingMessageEnvelope)messageEnvelopes.get(0)).getMessage();
        Assert.assertEquals((Object)OpMessage.Type.ELEMENT, (Object)impulseEvent.getType());
        Assert.assertTrue((boolean)(((IncomingMessageEnvelope)messageEnvelopes.get(1)).getMessage() instanceof WatermarkMessage));
        Assert.assertTrue((boolean)((IncomingMessageEnvelope)messageEnvelopes.get(2)).isEndOfStream());
    }

    private SystemStreamPartition sspForPartition(int i) {
        return new SystemStreamPartition("default-system", "default-stream", new Partition(i));
    }
}

