/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.translation;

import java.util.Map;
import org.apache.beam.runners.samza.SamzaExecutionEnvironment;
import org.apache.beam.runners.samza.SamzaPipelineOptions;
import org.apache.beam.runners.samza.SamzaRunner;
import org.apache.beam.runners.samza.translation.ConfigBuilder;
import org.apache.beam.runners.samza.translation.PViewToIdMapper;
import org.apache.beam.runners.samza.translation.SamzaPipelineTranslator;
import org.apache.beam.runners.samza.translation.SamzaTransformOverrides;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.apache.samza.config.Config;
import org.apache.samza.job.yarn.YarnJobFactory;
import org.apache.samza.runtime.LocalApplicationRunner;
import org.apache.samza.runtime.RemoteApplicationRunner;
import org.apache.samza.storage.kv.RocksDbKeyValueStorageEngineFactory;
import org.apache.samza.zk.ZkJobCoordinatorFactory;
import org.junit.Assert;
import org.junit.Test;

public class ConfigGeneratorTest {
    private static final String APP_RUNNER_CLASS = "app.runner.class";
    private static final String JOB_FACTORY_CLASS = "job.factory.class";

    @Test
    public void testBeamStoreConfig() {
        SamzaPipelineOptions options = (SamzaPipelineOptions)PipelineOptionsFactory.create().as(SamzaPipelineOptions.class);
        options.setJobName("TestStoreConfig");
        options.setRunner(SamzaRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)Sum.integersGlobally());
        pipeline.replaceAll(SamzaTransformOverrides.getDefaultOverrides());
        Map idMap = PViewToIdMapper.buildIdMap((Pipeline)pipeline);
        ConfigBuilder configBuilder = new ConfigBuilder(options);
        SamzaPipelineTranslator.createConfig((Pipeline)pipeline, (SamzaPipelineOptions)options, (Map)idMap, (ConfigBuilder)configBuilder);
        Config config = configBuilder.build();
        Assert.assertEquals((Object)RocksDbKeyValueStorageEngineFactory.class.getName(), (Object)config.get((Object)"stores.beamStore.factory"));
        Assert.assertEquals((Object)"byteSerde", (Object)config.get((Object)"stores.beamStore.key.serde"));
        Assert.assertEquals((Object)"byteSerde", (Object)config.get((Object)"stores.beamStore.msg.serde"));
        Assert.assertNull((Object)config.get((Object)"stores.beamStore.changelog"));
        options.setStateDurable(Boolean.valueOf(true));
        SamzaPipelineTranslator.createConfig((Pipeline)pipeline, (SamzaPipelineOptions)options, (Map)idMap, (ConfigBuilder)configBuilder);
        Config config2 = configBuilder.build();
        Assert.assertEquals((Object)"TestStoreConfig-1-beamStore-changelog", (Object)config2.get((Object)"stores.beamStore.changelog"));
    }

    @Test
    public void testSamzaLocalExecutionEnvironmentConfig() {
        SamzaPipelineOptions options = (SamzaPipelineOptions)PipelineOptionsFactory.create().as(SamzaPipelineOptions.class);
        options.setJobName("TestEnvConfig");
        options.setRunner(SamzaRunner.class);
        options.setSamzaExecutionEnvironment(SamzaExecutionEnvironment.LOCAL);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)Sum.integersGlobally());
        pipeline.replaceAll(SamzaTransformOverrides.getDefaultOverrides());
        Map idMap = PViewToIdMapper.buildIdMap((Pipeline)pipeline);
        ConfigBuilder configBuilder = new ConfigBuilder(options);
        SamzaPipelineTranslator.createConfig((Pipeline)pipeline, (SamzaPipelineOptions)options, (Map)idMap, (ConfigBuilder)configBuilder);
        Config config = configBuilder.build();
        Assert.assertTrue((boolean)Maps.difference((Map)config, (Map)ConfigBuilder.localRunConfig()).entriesOnlyOnRight().isEmpty());
    }

    @Test
    public void testSamzaYarnExecutionEnvironmentConfig() {
        String yarnPackagePath = "yarn.package.path";
        SamzaPipelineOptions options = (SamzaPipelineOptions)PipelineOptionsFactory.create().as(SamzaPipelineOptions.class);
        options.setJobName("TestEnvConfig");
        options.setRunner(SamzaRunner.class);
        options.setSamzaExecutionEnvironment(SamzaExecutionEnvironment.YARN);
        options.setConfigOverride((Map)ImmutableMap.builder().put((Object)"yarn.package.path", (Object)"file://${basedir}/target/${project.artifactId}-${pom.version}-dist.tar.gz").build());
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)Sum.integersGlobally());
        pipeline.replaceAll(SamzaTransformOverrides.getDefaultOverrides());
        Map idMap = PViewToIdMapper.buildIdMap((Pipeline)pipeline);
        ConfigBuilder configBuilder = new ConfigBuilder(options);
        SamzaPipelineTranslator.createConfig((Pipeline)pipeline, (SamzaPipelineOptions)options, (Map)idMap, (ConfigBuilder)configBuilder);
        try {
            Config config = configBuilder.build();
            Assert.assertEquals((Object)config.get((Object)APP_RUNNER_CLASS), (Object)RemoteApplicationRunner.class.getName());
            Assert.assertEquals((Object)config.get((Object)JOB_FACTORY_CLASS), (Object)YarnJobFactory.class.getName());
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError(String.format("Failed to validate correct configs for %s samza execution environment", SamzaExecutionEnvironment.YARN), e);
        }
    }

    @Test
    public void testSamzaStandAloneExecutionEnvironmentConfig() {
        SamzaPipelineOptions options = (SamzaPipelineOptions)PipelineOptionsFactory.create().as(SamzaPipelineOptions.class);
        options.setJobName("TestEnvConfig");
        options.setRunner(SamzaRunner.class);
        options.setSamzaExecutionEnvironment(SamzaExecutionEnvironment.STANDALONE);
        options.setConfigOverride((Map)ImmutableMap.builder().put((Object)"job.coordinator.zk.connect", (Object)"localhost:2181").build());
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)Sum.integersGlobally());
        pipeline.replaceAll(SamzaTransformOverrides.getDefaultOverrides());
        Map idMap = PViewToIdMapper.buildIdMap((Pipeline)pipeline);
        ConfigBuilder configBuilder = new ConfigBuilder(options);
        SamzaPipelineTranslator.createConfig((Pipeline)pipeline, (SamzaPipelineOptions)options, (Map)idMap, (ConfigBuilder)configBuilder);
        try {
            Config config = configBuilder.build();
            Assert.assertEquals((Object)config.get((Object)APP_RUNNER_CLASS), (Object)LocalApplicationRunner.class.getName());
            Assert.assertEquals((Object)config.get((Object)"job.coordinator.factory"), (Object)ZkJobCoordinatorFactory.class.getName());
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError(String.format("Failed to validate correct configs for %s samza execution environment", SamzaExecutionEnvironment.STANDALONE), e);
        }
    }

    @Test
    public void testUserStoreConfig() {
        SamzaPipelineOptions options = (SamzaPipelineOptions)PipelineOptionsFactory.create().as(SamzaPipelineOptions.class);
        options.setJobName("TestStoreConfig");
        options.setRunner(SamzaRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.empty((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.strings())))).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<String, String>, Void>(){
            private static final String testState = "testState";
            @DoFn.StateId(value="testState")
            private final StateSpec<ValueState<Integer>> state = StateSpecs.value();

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context, @DoFn.StateId(value="testState") ValueState<Integer> state) {
            }
        }));
        Map idMap = PViewToIdMapper.buildIdMap((Pipeline)pipeline);
        ConfigBuilder configBuilder = new ConfigBuilder(options);
        SamzaPipelineTranslator.createConfig((Pipeline)pipeline, (SamzaPipelineOptions)options, (Map)idMap, (ConfigBuilder)configBuilder);
        Config config = configBuilder.build();
        Assert.assertEquals((Object)RocksDbKeyValueStorageEngineFactory.class.getName(), (Object)config.get((Object)"stores.testState.factory"));
        Assert.assertEquals((Object)"byteSerde", (Object)config.get((Object)"stores.testState.key.serde"));
        Assert.assertEquals((Object)"byteSerde", (Object)config.get((Object)"stores.testState.msg.serde"));
        Assert.assertNull((Object)config.get((Object)"stores.testState.changelog"));
        options.setStateDurable(Boolean.valueOf(true));
        SamzaPipelineTranslator.createConfig((Pipeline)pipeline, (SamzaPipelineOptions)options, (Map)idMap, (ConfigBuilder)configBuilder);
        Config config2 = configBuilder.build();
        Assert.assertEquals((Object)"TestStoreConfig-1-testState-changelog", (Object)config2.get((Object)"stores.testState.changelog"));
    }
}

