/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.runtime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.samza.runtime.KeyedTimerData;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.joda.time.Instant;
import org.junit.Test;

public class KeyedTimerDataTest {
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();

    @Test
    public void testCoder() throws Exception {
        TimerInternals.TimerData td = TimerInternals.TimerData.of((String)"timer", (StateNamespace)StateNamespaces.global(), (Instant)new Instant(), (TimeDomain)TimeDomain.EVENT_TIME);
        String key = "timer-key";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        STRING_CODER.encode((Object)"timer-key", (OutputStream)baos);
        byte[] keyBytes = baos.toByteArray();
        KeyedTimerData ktd = new KeyedTimerData(keyBytes, (Object)"timer-key", td);
        KeyedTimerData.KeyedTimerDataCoder ktdCoder = new KeyedTimerData.KeyedTimerDataCoder(STRING_CODER, (Coder)GlobalWindow.Coder.INSTANCE);
        CoderProperties.coderDecodeEncodeEqual((Coder)ktdCoder, (Object)ktd);
    }
}

