/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.beam.runners.samza.runtime.OpMessage;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemStreamPartition;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.junit.Assert;

public class TestSourceHelpers {
    private TestSourceHelpers() {
    }

    static IncomingMessageEnvelope createElementMessage(SystemStreamPartition ssp, String offset, String element, Instant timestamp) {
        return new IncomingMessageEnvelope(ssp, offset, null, (Object)OpMessage.ofElement((WindowedValue)WindowedValue.timestampedValueInGlobalWindow((Object)element, (Instant)timestamp)));
    }

    static IncomingMessageEnvelope createWatermarkMessage(SystemStreamPartition ssp, Instant watermark) {
        return IncomingMessageEnvelope.buildWatermarkEnvelope((SystemStreamPartition)ssp, (long)watermark.getMillis());
    }

    static IncomingMessageEnvelope createEndOfStreamMessage(SystemStreamPartition ssp) {
        return IncomingMessageEnvelope.buildEndOfStreamEnvelope((SystemStreamPartition)ssp);
    }

    static <T> void expectWrappedException(Exception expectedException, Callable<T> callable) throws Exception {
        try {
            callable.call();
            Assert.fail((String)("Expected exception (" + expectedException + "), but no exception was thrown"));
        }
        catch (Exception e) {
            for (Throwable currentException = e; currentException != null; currentException = currentException.getCause()) {
                if (!currentException.equals(expectedException)) continue;
                return;
            }
            Assert.assertEquals((Object)expectedException, (Object)e);
        }
    }

    static abstract class SourceBuilder<T, W extends Source<T>> {
        private final List<Event<T>> events = new ArrayList<Event<T>>();
        private Instant currentTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;

        SourceBuilder() {
        }

        @SafeVarargs
        public final SourceBuilder<T, W> addElements(T ... elements) {
            for (T element : elements) {
                this.events.add(new ElementEvent(element, this.currentTimestamp));
            }
            return this;
        }

        public SourceBuilder<T, W> addException(IOException exception) {
            this.events.add(new ExceptionEvent(exception));
            return this;
        }

        public SourceBuilder<T, W> addLatch(CountDownLatch latch) {
            this.events.add(new LatchEvent(latch));
            return this;
        }

        public SourceBuilder<T, W> setTimestamp(Instant timestamp) {
            Assert.assertTrue((String)("Expected " + timestamp + " to be greater than or equal to " + this.currentTimestamp), (timestamp.isEqual((ReadableInstant)this.currentTimestamp) || timestamp.isAfter((ReadableInstant)this.currentTimestamp) ? 1 : 0) != 0);
            this.currentTimestamp = timestamp;
            return this;
        }

        public SourceBuilder<T, W> advanceWatermarkTo(Instant watermark) {
            this.events.add(new WatermarkEvent(watermark));
            return this;
        }

        public SourceBuilder<T, W> noElements() {
            this.events.add(new NoElementEvent());
            return this;
        }

        protected List<Event<T>> getEvents() {
            return this.events;
        }

        public abstract W build();
    }

    static class NoElementEvent<T>
    implements Event<T> {
        NoElementEvent() {
        }
    }

    static class LatchEvent<T>
    implements Event<T> {
        final CountDownLatch latch;

        private LatchEvent(CountDownLatch latch) {
            this.latch = latch;
        }
    }

    static class ExceptionEvent<T>
    implements Event<T> {
        final IOException exception;

        private ExceptionEvent(IOException exception) {
            this.exception = exception;
        }
    }

    static class WatermarkEvent<T>
    implements Event<T> {
        final Instant watermark;

        private WatermarkEvent(Instant watermark) {
            this.watermark = watermark;
        }
    }

    static class ElementEvent<T>
    implements Event<T> {
        final T element;
        final Instant timestamp;

        private ElementEvent(T element, Instant timestamp) {
            this.element = element;
            this.timestamp = timestamp;
        }
    }

    static interface Event<T> {
    }
}

