/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.samza.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.runners.samza.adapter.TestSourceHelpers;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.joda.time.Instant;

public class TestBoundedSource<T>
extends BoundedSource<T> {
    private final List<List<TestSourceHelpers.Event<T>>> events;

    public static <T> Builder<T> createBuilder() {
        return new Builder();
    }

    public static <T> SplittableBuilder<T> createSplits(int numSplits) {
        return new SplittableBuilder(numSplits);
    }

    private TestBoundedSource(List<List<TestSourceHelpers.Event<T>>> events) {
        this.events = Collections.unmodifiableList(new ArrayList<List<TestSourceHelpers.Event<T>>>(events));
    }

    public List<? extends BoundedSource<T>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        return this.events.stream().map(ev -> new TestBoundedSource(Collections.singletonList(ev))).collect(Collectors.toList());
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return this.events.size();
    }

    public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
        assert (this.events.size() == 1);
        return new Reader(this.events.get(0));
    }

    public void validate() {
    }

    private class Reader
    extends BoundedSource.BoundedReader<T> {
        private final List<TestSourceHelpers.Event<T>> events;
        private boolean started;
        private boolean finished;
        private int index = -1;

        private Reader(List<TestSourceHelpers.Event<T>> events) {
            this.events = events;
        }

        public boolean start() throws IOException {
            if (this.started) {
                throw new IllegalStateException("Start called when reader was already started");
            }
            this.started = true;
            return this.advance();
        }

        public boolean advance() throws IOException {
            if (!this.started) {
                throw new IllegalStateException("Advance called when reader was not started");
            }
            if (this.finished) {
                return false;
            }
            ++this.index;
            while (this.index < this.events.size()) {
                TestSourceHelpers.Event event = this.events.get(this.index);
                if (event instanceof TestSourceHelpers.ExceptionEvent) {
                    throw ((TestSourceHelpers.ExceptionEvent)event).exception;
                }
                if (event instanceof TestSourceHelpers.LatchEvent) {
                    try {
                        ((TestSourceHelpers.LatchEvent)event).latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    return true;
                }
                ++this.index;
            }
            this.finished = true;
            return false;
        }

        public T getCurrent() throws NoSuchElementException {
            if (!this.started || this.finished) {
                throw new NoSuchElementException();
            }
            TestSourceHelpers.Event event = this.events.get(this.index);
            assert (event instanceof TestSourceHelpers.ElementEvent);
            return ((TestSourceHelpers.ElementEvent)event).element;
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            if (!this.started || this.finished) {
                throw new NoSuchElementException();
            }
            TestSourceHelpers.Event event = this.events.get(this.index);
            assert (event instanceof TestSourceHelpers.ElementEvent);
            return ((TestSourceHelpers.ElementEvent)event).timestamp;
        }

        public void close() throws IOException {
        }

        public BoundedSource<T> getCurrentSource() {
            return TestBoundedSource.this;
        }
    }

    public static class SplittableBuilder<T>
    extends TestSourceHelpers.SourceBuilder<T, TestBoundedSource<T>> {
        private final List<Builder<T>> builders = new ArrayList<Builder<T>>();

        private SplittableBuilder(int splits) {
            while (splits != 0) {
                this.builders.add(new Builder());
                --splits;
            }
        }

        @Override
        public TestBoundedSource<T> build() {
            ArrayList events = new ArrayList();
            this.builders.forEach(builder -> events.add(builder.getEvents()));
            return new TestBoundedSource(events);
        }

        public Builder<T> forSplit(int split) {
            return this.builders.get(split);
        }
    }

    public static class Builder<T>
    extends TestSourceHelpers.SourceBuilder<T, TestBoundedSource<T>> {
        @Override
        public TestBoundedSource<T> build() {
            return new TestBoundedSource(Collections.singletonList(this.getEvents()));
        }
    }
}

