/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.reference;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.beam_runners_reference_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_reference_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_reference_java.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_runners_reference_java.com.google.common.collect.Sets;
import org.apache.beam.runners.core.construction.ArtifactServiceStager;
import org.apache.beam.runners.core.construction.JavaReadViaImpulse;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.core.construction.PipelineResources;
import org.apache.beam.runners.core.construction.PipelineTranslation;
import org.apache.beam.runners.reference.CloseableResource;
import org.apache.beam.runners.reference.JobServicePipelineResult;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.ZipFiles;
import org.apache.beam.vendor.grpc.v1.io.grpc.Channel;
import org.apache.beam.vendor.grpc.v1.io.grpc.ManagedChannel;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableRunner
extends PipelineRunner<PipelineResult> {
    private static final Logger LOG = LoggerFactory.getLogger(PortableRunner.class);
    private final PipelineOptions options;
    private final String endpoint;
    private final Collection<ArtifactServiceStager.StagedFile> filesToStage;
    private final ManagedChannelFactory channelFactory;

    public static PortableRunner fromOptions(PipelineOptions options) {
        return PortableRunner.create(options, ManagedChannelFactory.createDefault());
    }

    @VisibleForTesting
    static PortableRunner create(PipelineOptions options, ManagedChannelFactory channelFactory) {
        PortablePipelineOptions portableOptions = (PortablePipelineOptions)PipelineOptionsValidator.validate(PortablePipelineOptions.class, (PipelineOptions)options);
        String endpoint = portableOptions.getJobEndpoint();
        HashSet pathsToStage = Sets.newHashSet();
        if (portableOptions.getFilesToStage() == null) {
            pathsToStage.addAll(PipelineResources.detectClassPathResourcesToStage((ClassLoader)PortableRunner.class.getClassLoader()));
            if (pathsToStage.isEmpty()) {
                throw new IllegalArgumentException("No classpath elements found.");
            }
            LOG.debug("PortablePipelineOptions.filesToStage was not specified. Defaulting to files from the classpath: {}", (Object)pathsToStage.size());
        } else {
            pathsToStage.addAll(portableOptions.getFilesToStage());
        }
        ImmutableList.Builder filesToStage = ImmutableList.builder();
        for (String path : pathsToStage) {
            File file = new File(path);
            if (!new File(path).exists()) continue;
            if (file.isDirectory()) {
                try {
                    filesToStage.add((Object)PortableRunner.createStagingFile(PortableRunner.zipDirectory(file)));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            filesToStage.add((Object)PortableRunner.createStagingFile(file));
        }
        return new PortableRunner(options, endpoint, (Collection<ArtifactServiceStager.StagedFile>)filesToStage.build(), channelFactory);
    }

    private PortableRunner(PipelineOptions options, String endpoint, Collection<ArtifactServiceStager.StagedFile> filesToStage, ManagedChannelFactory channelFactory) {
        this.options = options;
        this.endpoint = endpoint;
        this.filesToStage = filesToStage;
        this.channelFactory = channelFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PipelineResult run(Pipeline pipeline) {
        pipeline.replaceAll((List)ImmutableList.of((Object)JavaReadViaImpulse.boundedOverride()));
        LOG.debug("Initial files to stage: " + this.filesToStage);
        JobApi.PrepareJobRequest prepareJobRequest = JobApi.PrepareJobRequest.newBuilder().setJobName(this.options.getJobName()).setPipeline(PipelineTranslation.toProto((Pipeline)pipeline)).setPipelineOptions(PipelineOptionsTranslation.toProto((PipelineOptions)this.options)).build();
        LOG.info("Using job server endpoint: {}", (Object)this.endpoint);
        ManagedChannel jobServiceChannel = this.channelFactory.forDescriptor(Endpoints.ApiServiceDescriptor.newBuilder().setUrl(this.endpoint).build());
        JobServiceGrpc.JobServiceBlockingStub jobService = JobServiceGrpc.newBlockingStub((Channel)jobServiceChannel);
        try (CloseableResource<JobServiceGrpc.JobServiceBlockingStub> wrappedJobService = CloseableResource.of(jobService, unused -> jobServiceChannel.shutdown());){
            JobApi.PrepareJobResponse prepareJobResponse = jobService.prepare(prepareJobRequest);
            LOG.info("PrepareJobResponse: {}", (Object)prepareJobResponse);
            Endpoints.ApiServiceDescriptor artifactStagingEndpoint = prepareJobResponse.getArtifactStagingEndpoint();
            String stagingSessionToken = prepareJobResponse.getStagingSessionToken();
            String retrievalToken = null;
            try (CloseableResource<ManagedChannel> artifactChannel = CloseableResource.of(this.channelFactory.forDescriptor(artifactStagingEndpoint), ManagedChannel::shutdown);){
                ArtifactServiceStager stager = ArtifactServiceStager.overChannel((Channel)((Channel)artifactChannel.get()));
                LOG.debug("Actual files staged: {}", this.filesToStage);
                retrievalToken = stager.stage(stagingSessionToken, this.filesToStage);
            }
            catch (CloseableResource.CloseException e) {
                LOG.warn("Error closing artifact staging channel", (Throwable)e);
                Preconditions.checkState((retrievalToken != null ? 1 : 0) != 0);
            }
            catch (Exception e) {
                throw new RuntimeException("Error staging files.", e);
            }
            JobApi.RunJobRequest runJobRequest = JobApi.RunJobRequest.newBuilder().setPreparationId(prepareJobResponse.getPreparationId()).setRetrievalToken(retrievalToken).build();
            JobApi.RunJobResponse runJobResponse = jobService.run(runJobRequest);
            LOG.info("RunJobResponse: {}", (Object)runJobResponse);
            ByteString jobId = runJobResponse.getJobIdBytes();
            JobServicePipelineResult jobServicePipelineResult = new JobServicePipelineResult(jobId, wrappedJobService.transfer());
            return jobServicePipelineResult;
        }
        catch (CloseableResource.CloseException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "PortableRunner#" + ((Object)((Object)this)).hashCode();
    }

    private static File zipDirectory(File directory) throws IOException {
        File zipFile = File.createTempFile(directory.getName(), ".zip");
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            ZipFiles.zipDirectory((File)directory, (OutputStream)fos);
        }
        return zipFile;
    }

    private static ArtifactServiceStager.StagedFile createStagingFile(File file) {
        return ArtifactServiceStager.StagedFile.of((File)file, (String)UUID.randomUUID().toString());
    }

    private static String escapePath(String path) {
        StringBuilder result = new StringBuilder(2 * path.length());
        block6: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '_': {
                    result.append("__");
                    continue block6;
                }
                case '/': {
                    result.append("_.");
                    continue block6;
                }
                case '\\': {
                    result.append("._");
                    continue block6;
                }
                case '.': {
                    result.append("..");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

