/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.reference;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.runners.reference.CloseableResource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloseableResourceTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void alwaysReturnsSameResource() {
        Foo foo = new Foo();
        CloseableResource resource = CloseableResource.of((Object)foo, ignored -> {});
        MatcherAssert.assertThat((Object)((Foo)resource.get()), (Matcher)Matchers.is((Object)foo));
        MatcherAssert.assertThat((Object)((Foo)resource.get()), (Matcher)Matchers.is((Object)foo));
    }

    @Test
    public void callsCloser() throws Exception {
        AtomicBoolean closed = new AtomicBoolean(false);
        CloseableResource ignored = CloseableResource.of((Object)new Foo(), foo -> closed.set(true));
        Throwable throwable = null;
        if (ignored != null) {
            CloseableResourceTest.$closeResource(throwable, (AutoCloseable)ignored);
        }
        MatcherAssert.assertThat((Object)closed.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void wrapsExceptionsInCloseException() throws Exception {
        Exception wrapped = new Exception();
        this.thrown.expect(CloseableResource.CloseException.class);
        this.thrown.expectCause(Matchers.is((Object)wrapped));
        CloseableResource ignored = CloseableResource.of((Object)new Foo(), foo -> {
            throw wrapped;
        });
        Throwable throwable = null;
        if (ignored != null) {
            CloseableResourceTest.$closeResource(throwable, (AutoCloseable)ignored);
        }
    }

    @Test
    public void transferReleasesCloser() throws Exception {
        try (CloseableResource foo = CloseableResource.of((Object)new Foo(), unused -> Assert.fail((String)"Transferred resource should not be closed"));){
            foo.transfer();
        }
    }

    @Test
    public void transferMovesOwnership() throws Exception {
        AtomicBoolean closed = new AtomicBoolean(false);
        CloseableResource original = CloseableResource.of((Object)new Foo(), unused -> closed.set(true));
        CloseableResource transferred = original.transfer();
        transferred.close();
        MatcherAssert.assertThat((Object)closed.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void cannotTransferClosed() throws Exception {
        CloseableResource foo = CloseableResource.of((Object)new Foo(), unused -> {});
        foo.close();
        this.thrown.expect(IllegalStateException.class);
        foo.transfer();
    }

    @Test
    public void cannotTransferTwice() {
        CloseableResource foo = CloseableResource.of((Object)new Foo(), unused -> {});
        foo.transfer();
        this.thrown.expect(IllegalStateException.class);
        foo.transfer();
    }

    private static class Foo {
        private Foo() {
        }
    }
}

