/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.reference.testing;

import java.lang.reflect.InvocationTargetException;
import org.apache.beam.runners.reference.PortableRunner;
import org.apache.beam.runners.reference.testing.TestPortablePipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPortableRunner
extends PipelineRunner<PipelineResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TestPortableRunner.class);
    private final PortablePipelineOptions options;

    private TestPortableRunner(PortablePipelineOptions options) {
        this.options = options;
    }

    public static TestPortableRunner fromOptions(PipelineOptions options) {
        return new TestPortableRunner((PortablePipelineOptions)options.as(PortablePipelineOptions.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineResult run(Pipeline pipeline) {
        PipelineResult pipelineResult;
        String jobServerHostPort;
        Object jobServerDriver;
        TestPortablePipelineOptions testPortablePipelineOptions = (TestPortablePipelineOptions)this.options.as(TestPortablePipelineOptions.class);
        Class jobServerDriverClass = testPortablePipelineOptions.getJobServerDriver();
        String[] parameters = testPortablePipelineOptions.getJobServerConfig();
        try {
            jobServerDriver = InstanceBuilder.ofType((Class)jobServerDriverClass).fromFactoryMethod("fromParams").withArg(String[].class, (Object)parameters).build();
            jobServerHostPort = (String)jobServerDriverClass.getMethod("start", new Class[0]).invoke(jobServerDriver, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            PortablePipelineOptions portableOptions = (PortablePipelineOptions)this.options.as(PortablePipelineOptions.class);
            portableOptions.setRunner(PortableRunner.class);
            portableOptions.setJobEndpoint(jobServerHostPort);
            PortableRunner runner = PortableRunner.fromOptions((PipelineOptions)portableOptions);
            PipelineResult result = runner.run(pipeline);
            MatcherAssert.assertThat((String)"Pipeline did not succeed.", (Object)result.waitUntilFinish(), (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
            pipelineResult = result;
        }
        catch (Throwable throwable) {
            try {
                jobServerDriverClass.getMethod("stop", new Class[0]).invoke(jobServerDriver, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error(String.format("Provided JobServiceDriver %s does not implement stop().", jobServerDriverClass), (Throwable)e);
            }
            throw throwable;
        }
        try {
            jobServerDriverClass.getMethod("stop", new Class[0]).invoke(jobServerDriver, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error(String.format("Provided JobServiceDriver %s does not implement stop().", jobServerDriverClass), (Throwable)e);
        }
        return pipelineResult;
    }
}

