/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.reference;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.runners.reference.CloseableResource;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.ByteString;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobServicePipelineResult
implements PipelineResult,
AutoCloseable {
    private static final long POLL_INTERVAL_MS = 10000L;
    private static final Logger LOG = LoggerFactory.getLogger(JobServicePipelineResult.class);
    private final ByteString jobId;
    private final CloseableResource<JobServiceGrpc.JobServiceBlockingStub> jobService;
    @Nullable
    private PipelineResult.State terminationState;
    @Nullable
    private final Runnable cleanup;

    JobServicePipelineResult(ByteString jobId, CloseableResource<JobServiceGrpc.JobServiceBlockingStub> jobService, Runnable cleanup) {
        this.jobId = jobId;
        this.jobService = jobService;
        this.terminationState = null;
        this.cleanup = cleanup;
    }

    public PipelineResult.State getState() {
        if (this.terminationState != null) {
            return this.terminationState;
        }
        JobServiceGrpc.JobServiceBlockingStub stub = this.jobService.get();
        JobApi.GetJobStateResponse response = stub.getState(JobApi.GetJobStateRequest.newBuilder().setJobIdBytes(this.jobId).build());
        return JobServicePipelineResult.getJavaState(response.getState());
    }

    public PipelineResult.State cancel() {
        JobServiceGrpc.JobServiceBlockingStub stub = this.jobService.get();
        JobApi.CancelJobResponse response = stub.cancel(JobApi.CancelJobRequest.newBuilder().setJobIdBytes(this.jobId).build());
        return JobServicePipelineResult.getJavaState(response.getState());
    }

    @Nullable
    public PipelineResult.State waitUntilFinish(Duration duration) {
        if (duration.compareTo((ReadableDuration)Duration.millis((long)1L)) < 1) {
            return this.waitUntilFinish();
        }
        CompletableFuture<PipelineResult.State> result = CompletableFuture.supplyAsync(this::waitUntilFinish);
        try {
            return result.get(duration.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public PipelineResult.State waitUntilFinish() {
        if (this.terminationState != null) {
            return this.terminationState;
        }
        JobServiceGrpc.JobServiceBlockingStub stub = this.jobService.get();
        JobApi.GetJobStateRequest request = JobApi.GetJobStateRequest.newBuilder().setJobIdBytes(this.jobId).build();
        JobApi.GetJobStateResponse response = stub.getState(request);
        PipelineResult.State lastState = JobServicePipelineResult.getJavaState(response.getState());
        while (!lastState.isTerminal()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            response = stub.getState(request);
            lastState = JobServicePipelineResult.getJavaState(response.getState());
        }
        this.close();
        this.terminationState = lastState;
        return lastState;
    }

    public MetricResults metrics() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void close() {
        try (CloseableResource<JobServiceGrpc.JobServiceBlockingStub> jobService = this.jobService;){
            if (this.cleanup != null) {
                this.cleanup.run();
            }
        }
        catch (Exception e) {
            LOG.warn("Error cleaning up job service", (Throwable)e);
        }
    }

    private static PipelineResult.State getJavaState(JobApi.JobState.Enum protoState) {
        switch (protoState) {
            case UNSPECIFIED: {
                return PipelineResult.State.UNKNOWN;
            }
            case STOPPED: {
                return PipelineResult.State.STOPPED;
            }
            case RUNNING: {
                return PipelineResult.State.RUNNING;
            }
            case DONE: {
                return PipelineResult.State.DONE;
            }
            case FAILED: {
                return PipelineResult.State.FAILED;
            }
            case CANCELLED: {
                return PipelineResult.State.CANCELLED;
            }
            case UPDATED: {
                return PipelineResult.State.UPDATED;
            }
            case DRAINING: {
                return PipelineResult.State.UNKNOWN;
            }
            case DRAINED: {
                return PipelineResult.State.UNKNOWN;
            }
            case STARTING: {
                return PipelineResult.State.RUNNING;
            }
            case CANCELLING: {
                return PipelineResult.State.CANCELLED;
            }
        }
        LOG.warn("Unrecognized state from server: {}", (Object)protoState);
        return PipelineResult.State.UNKNOWN;
    }
}

