/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.reference;

import javax.annotation.Nullable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class CloseableResource<T>
implements AutoCloseable {
    private final T resource;
    @Nullable
    private Closer<T> closer;
    private boolean isClosed = false;

    private CloseableResource(T resource, Closer<T> closer) {
        this.resource = resource;
        this.closer = closer;
    }

    public static <T> CloseableResource<T> of(T resource, Closer<T> closer) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"Resource must be non-null");
        Preconditions.checkArgument((closer != null ? 1 : 0) != 0, (String)"%s must be non-null", (Object)Closer.class.getName());
        return new CloseableResource<T>(resource, closer);
    }

    public T get() {
        Preconditions.checkState((this.closer != null ? 1 : 0) != 0, (String)"%s has transferred ownership", (Object)CloseableResource.class.getName());
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"% is closed", (Object)CloseableResource.class.getName());
        return this.resource;
    }

    public CloseableResource<T> transfer() {
        Preconditions.checkState((this.closer != null ? 1 : 0) != 0, (String)"%s has transferred ownership", (Object)CloseableResource.class.getName());
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"% is closed", (Object)CloseableResource.class.getName());
        CloseableResource<T> other = CloseableResource.of(this.resource, this.closer);
        this.closer = null;
        return other;
    }

    @Override
    public void close() throws CloseException {
        if (this.closer != null && !this.isClosed) {
            try {
                this.closer.close(this.resource);
            }
            catch (Exception e) {
                throw new CloseException(e);
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public static class CloseException
    extends Exception {
        private CloseException(Exception e) {
            super("Error closing resource", e);
        }
    }

    @FunctionalInterface
    public static interface Closer<T> {
        public void close(T var1) throws Exception;
    }
}

