/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.reference.testing;

import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.jobmanagement.v1.JobServiceGrpc;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.stub.StreamObserver;

public class TestJobService
extends JobServiceGrpc.JobServiceImplBase {
    private final Endpoints.ApiServiceDescriptor stagingEndpoint;
    private final String preparationId;
    private final String jobId;
    private final JobApi.JobState.Enum jobState;

    public TestJobService(Endpoints.ApiServiceDescriptor stagingEndpoint, String preparationId, String jobId, JobApi.JobState.Enum jobState) {
        this.stagingEndpoint = stagingEndpoint;
        this.preparationId = preparationId;
        this.jobId = jobId;
        this.jobState = jobState;
    }

    public void prepare(JobApi.PrepareJobRequest request, StreamObserver<JobApi.PrepareJobResponse> responseObserver) {
        responseObserver.onNext((Object)JobApi.PrepareJobResponse.newBuilder().setPreparationId(this.preparationId).setArtifactStagingEndpoint(this.stagingEndpoint).setStagingSessionToken("TestStagingToken").build());
        responseObserver.onCompleted();
    }

    public void run(JobApi.RunJobRequest request, StreamObserver<JobApi.RunJobResponse> responseObserver) {
        responseObserver.onNext((Object)JobApi.RunJobResponse.newBuilder().setJobId(this.jobId).build());
        responseObserver.onCompleted();
    }

    public void getState(JobApi.GetJobStateRequest request, StreamObserver<JobApi.GetJobStateResponse> responseObserver) {
        responseObserver.onNext((Object)JobApi.GetJobStateResponse.newBuilder().setState(this.jobState).build());
        responseObserver.onCompleted();
    }
}

