/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.reference;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.model.jobmanagement.v1.JobApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.runners.core.construction.InMemoryArtifactStagerService;
import org.apache.beam.runners.reference.CloseableResource;
import org.apache.beam.runners.reference.PortableRunner;
import org.apache.beam.runners.reference.testing.TestJobService;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.fn.channel.ManagedChannelFactory;
import org.apache.beam.sdk.fn.test.InProcessManagedChannelFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.BindableService;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Server;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.inprocess.InProcessServerBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PortableRunnerTest
implements Serializable {
    private static final String ENDPOINT_URL = "foo:3000";
    private static final Endpoints.ApiServiceDescriptor ENDPOINT_DESCRIPTOR = Endpoints.ApiServiceDescriptor.newBuilder().setUrl("foo:3000").build();
    private final PipelineOptions options = PortableRunnerTest.createPipelineOptions();
    @Rule
    public transient TestPipeline p = TestPipeline.fromOptions((PipelineOptions)this.options);

    @Test
    public void stagesAndRunsJob() throws Exception {
        try (CloseableResource<Server> server = PortableRunnerTest.createJobServer(JobApi.JobState.Enum.DONE);){
            PortableRunner runner = PortableRunner.create((PipelineOptions)this.options, (ManagedChannelFactory)InProcessManagedChannelFactory.create());
            PipelineResult.State state = runner.run((Pipeline)this.p).waitUntilFinish();
            MatcherAssert.assertThat((Object)state, (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
        }
    }

    private static CloseableResource<Server> createJobServer(JobApi.JobState.Enum jobState) throws IOException {
        CloseableResource server = CloseableResource.of((Object)((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)ENDPOINT_URL).addService((BindableService)new TestJobService(ENDPOINT_DESCRIPTOR, "prepId", "jobId", jobState))).addService((BindableService)new InMemoryArtifactStagerService())).build(), Server::shutdown);
        ((Server)server.get()).start();
        return server;
    }

    private static PipelineOptions createPipelineOptions() {
        PortablePipelineOptions options = (PortablePipelineOptions)PipelineOptionsFactory.create().as(PortablePipelineOptions.class);
        options.setJobEndpoint(ENDPOINT_URL);
        options.setRunner(PortableRunner.class);
        return options;
    }
}

