/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet.processors;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.beam.runners.jet.Utils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Instant;

public class ViewP
extends AbstractProcessor {
    private final TimestampCombiner timestampCombiner;
    private final Coder inputCoder;
    private final Coder outputCoder;
    private final String ownerId;
    private Map<BoundedWindow, TimestampAndValues> values = new HashMap<BoundedWindow, TimestampAndValues>();
    private Traverser<byte[]> resultTraverser;

    private ViewP(Coder inputCoder, Coder outputCoder, WindowingStrategy windowingStrategy, String ownerId) {
        this.timestampCombiner = windowingStrategy.getTimestampCombiner();
        this.inputCoder = inputCoder;
        this.outputCoder = Utils.deriveIterableValueCoder((WindowedValue.FullWindowedValueCoder)outputCoder);
        this.ownerId = ownerId;
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        WindowedValue windowedValue = Utils.decodeWindowedValue((byte[])item, this.inputCoder);
        for (BoundedWindow window : windowedValue.getWindows()) {
            this.values.merge(window, new TimestampAndValues(windowedValue.getPane(), windowedValue.getTimestamp(), windowedValue.getValue()), (o, n) -> o.merge(this.timestampCombiner, (TimestampAndValues)n));
        }
        return true;
    }

    public boolean complete() {
        if (this.resultTraverser == null) {
            this.resultTraverser = Traversers.traverseStream(this.values.entrySet().stream().map(e -> {
                WindowedValue outputValue = WindowedValue.of((Object)((TimestampAndValues)e.getValue()).values, (Instant)((TimestampAndValues)e.getValue()).timestamp, Collections.singleton((BoundedWindow)e.getKey()), (PaneInfo)((TimestampAndValues)e.getValue()).pane);
                return Utils.encode(outputValue, this.outputCoder);
            }));
        }
        return this.emitFromTraverser(this.resultTraverser);
    }

    public static SupplierEx<Processor> supplier(Coder inputCoder, Coder outputCoder, WindowingStrategy<?, ?> windowingStrategy, String ownerId) {
        return (SupplierEx & Serializable)() -> new ViewP(inputCoder, outputCoder, windowingStrategy, ownerId);
    }

    private static class TimestampAndValues {
        private final List<Object> values = new ArrayList<Object>();
        private Instant timestamp;
        private PaneInfo pane;

        TimestampAndValues(PaneInfo pane, Instant timestamp, Object value) {
            this.pane = pane;
            this.timestamp = timestamp;
            this.values.add(value);
        }

        public Iterable<Object> getValues() {
            return this.values;
        }

        TimestampAndValues merge(TimestampCombiner timestampCombiner, TimestampAndValues other) {
            this.pane = other.pane;
            this.timestamp = timestampCombiner.combine(new Instant[]{this.timestamp, other.timestamp});
            this.values.addAll(other.values);
            return this;
        }
    }
}

