/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet.processors;

import com.hazelcast.cluster.Address;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.beam.runners.jet.Utils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;

public class ImpulseP
extends AbstractProcessor {
    private final boolean active;
    private final Coder outputCoder;
    private final String ownerId;

    private ImpulseP(boolean active, Coder outputCoder, String ownerId) {
        this.active = active;
        this.outputCoder = outputCoder;
        this.ownerId = ownerId;
    }

    public boolean complete() {
        if (this.active) {
            return this.tryEmit(Utils.encode(WindowedValue.valueInGlobalWindow((Object)new byte[0]), this.outputCoder));
        }
        return true;
    }

    public static ProcessorMetaSupplier supplier(Coder outputCoder, String ownerId) {
        return new ImpulseMetaProcessorSupplier(outputCoder, ownerId);
    }

    private static class ImpulseProcessorSupplier<T>
    implements ProcessorSupplier {
        private final Coder outputCoder;
        private final String ownerId;
        private transient ProcessorSupplier.Context context;

        private ImpulseProcessorSupplier(Coder outputCoder, String ownerId) {
            this.outputCoder = outputCoder;
            this.ownerId = ownerId;
        }

        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.context = context;
        }

        @Nonnull
        public Collection<? extends Processor> get(int count) {
            int indexBase = this.context.memberIndex() * this.context.localParallelism();
            ArrayList<ImpulseP> res = new ArrayList<ImpulseP>(count);
            int i = 0;
            while (i < count) {
                res.add(new ImpulseP(indexBase == 0, this.outputCoder, this.ownerId));
                ++i;
                ++indexBase;
            }
            return res;
        }
    }

    private static class ImpulseMetaProcessorSupplier
    implements ProcessorMetaSupplier {
        private final Coder outputCoder;
        private final String ownerId;

        private ImpulseMetaProcessorSupplier(Coder outputCoder, String ownerId) {
            this.outputCoder = outputCoder;
            this.ownerId = ownerId;
        }

        @Nonnull
        public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            return address -> new ImpulseProcessorSupplier(this.outputCoder, this.ownerId);
        }
    }
}

