/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet.processors;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.beam.runners.jet.DAGBuilder;
import org.apache.beam.runners.jet.Utils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;

public class FlattenP
extends AbstractProcessor {
    private final Map<Integer, Coder> inputOrdinalCoders;
    private final Coder outputCoder;
    private final String ownerId;

    private FlattenP(Map<Integer, Coder> inputOrdinalCoders, Coder outputCoder, String ownerId) {
        this.inputOrdinalCoders = inputOrdinalCoders;
        this.outputCoder = outputCoder;
        this.ownerId = ownerId;
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        Coder inputCoder = this.inputOrdinalCoders.get(ordinal);
        WindowedValue windowedValue = Utils.decodeWindowedValue((byte[])item, inputCoder);
        return this.tryEmit(Utils.encode(windowedValue, this.outputCoder));
    }

    public static final class Supplier
    implements SupplierEx<Processor>,
    DAGBuilder.WiringListener {
        private final Map<String, Coder> inputCollectionCoders;
        private final Coder outputCoder;
        private final String ownerId;
        private final Map<Integer, Coder> inputOrdinalCoders;

        public Supplier(Map<String, Coder> inputCoders, Coder outputCoder, String ownerId) {
            this.inputCollectionCoders = inputCoders;
            this.outputCoder = outputCoder;
            this.ownerId = ownerId;
            this.inputOrdinalCoders = new HashMap<Integer, Coder>();
        }

        public Processor getEx() {
            return new FlattenP(this.inputOrdinalCoders, this.outputCoder, this.ownerId);
        }

        @Override
        public void isOutboundEdgeOfVertex(Edge edge, String edgeId, String pCollId, String vertexId) {
        }

        @Override
        public void isInboundEdgeOfVertex(Edge edge, String edgeId, String pCollId, String vertexId) {
            if (this.ownerId.equals(vertexId)) {
                Coder coder = this.inputCollectionCoders.get(edgeId);
                this.inputOrdinalCoders.put(edge.getDestOrdinal(), coder);
            }
        }
    }
}

