/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet.processors;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.beam.runners.jet.Utils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Instant;

public class AssignWindowP<T>
extends AbstractProcessor {
    private final String ownerId;
    private final ResettableSingletonTraverser<byte[]> traverser = new ResettableSingletonTraverser();
    private final AbstractProcessor.FlatMapper<byte[], byte[]> flatMapper;
    private final WindowAssignContext<T> windowAssignContext;

    private AssignWindowP(Coder inputCoder, Coder outputCoder, WindowingStrategy<T, BoundedWindow> windowingStrategy, String ownerId) {
        this.ownerId = ownerId;
        this.windowAssignContext = new WindowAssignContext(windowingStrategy.getWindowFn());
        this.flatMapper = this.flatMapper(item -> {
            Collection windows;
            WindowedValue inputValue = Utils.decodeWindowedValue(item, inputCoder);
            this.windowAssignContext.setValue(inputValue);
            try {
                windows = windowingStrategy.getWindowFn().assignWindows(this.windowAssignContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            WindowedValue outputValue = WindowedValue.of((Object)inputValue.getValue(), (Instant)inputValue.getTimestamp(), (Collection)windows, (PaneInfo)inputValue.getPane());
            this.traverser.accept((Object)Utils.encode(outputValue, outputCoder));
            return this.traverser;
        });
    }

    public static <T> SupplierEx<Processor> supplier(Coder inputCoder, Coder outputCoder, WindowingStrategy<T, BoundedWindow> windowingStrategy, String ownerId) {
        return (SupplierEx & Serializable)() -> new AssignWindowP(inputCoder, outputCoder, windowingStrategy, ownerId);
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        return this.flatMapper.tryProcess((Object)((byte[])item));
    }

    private static class WindowAssignContext<InputT>
    extends WindowFn.AssignContext {
        private WindowedValue<InputT> value;

        WindowAssignContext(WindowFn<InputT, BoundedWindow> fn) {
            super(fn);
        }

        public void setValue(WindowedValue<InputT> value) {
            if (Iterables.size((Iterable)value.getWindows()) != 1) {
                throw new IllegalArgumentException(String.format("%s passed to window assignment must be in a single window, but it was in %s: %s", WindowedValue.class.getSimpleName(), Iterables.size((Iterable)value.getWindows()), value.getWindows()));
            }
            this.value = value;
        }

        public InputT element() {
            return (InputT)this.value.getValue();
        }

        public Instant timestamp() {
            return this.value.getTimestamp();
        }

        public BoundedWindow window() {
            return (BoundedWindow)Iterables.getOnlyElement((Iterable)this.value.getWindows());
        }
    }
}

