/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet.metrics;

import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.map.IMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MetricUpdates;
import org.apache.beam.runners.jet.metrics.AbstractMetric;
import org.apache.beam.runners.jet.metrics.CounterImpl;
import org.apache.beam.runners.jet.metrics.DistributionImpl;
import org.apache.beam.runners.jet.metrics.GaugeImpl;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class JetMetricsContainer
implements MetricsContainer {
    private final String stepName;
    private final String metricsKey;
    private final Map<MetricName, CounterImpl> counters = new HashMap<MetricName, CounterImpl>();
    private final Map<MetricName, DistributionImpl> distributions = new HashMap<MetricName, DistributionImpl>();
    private final Map<MetricName, GaugeImpl> gauges = new HashMap<MetricName, GaugeImpl>();
    private final IMap<String, MetricUpdates> accumulator;

    public static String getMetricsMapName(long jobId) {
        return Util.idToString((long)jobId) + "_METRICS";
    }

    public JetMetricsContainer(String stepName, String ownerId, Processor.Context context) {
        this.metricsKey = context.globalProcessorIndex() + "/" + stepName + "/" + ownerId;
        this.stepName = stepName;
        this.accumulator = context.jetInstance().getMap(JetMetricsContainer.getMetricsMapName(context.jobId()));
    }

    public Counter getCounter(MetricName metricName) {
        return this.counters.computeIfAbsent(metricName, CounterImpl::new);
    }

    public Distribution getDistribution(MetricName metricName) {
        return this.distributions.computeIfAbsent(metricName, DistributionImpl::new);
    }

    public Gauge getGauge(MetricName metricName) {
        return this.gauges.computeIfAbsent(metricName, GaugeImpl::new);
    }

    public void flush(boolean async) {
        if (this.counters.isEmpty() && this.distributions.isEmpty() && this.gauges.isEmpty()) {
            return;
        }
        ImmutableList counters = this.extractUpdates(this.counters);
        ImmutableList distributions = this.extractUpdates(this.distributions);
        ImmutableList gauges = this.extractUpdates(this.gauges);
        MetricUpdatesImpl updates = new MetricUpdatesImpl((Iterable<MetricUpdates.MetricUpdate<Long>>)counters, (Iterable<MetricUpdates.MetricUpdate<DistributionData>>)distributions, (Iterable<MetricUpdates.MetricUpdate<GaugeData>>)gauges);
        if (async) {
            this.accumulator.setAsync((Object)this.metricsKey, (Object)updates);
        } else {
            this.accumulator.set((Object)this.metricsKey, (Object)updates);
        }
    }

    private <UpdateT, CellT extends AbstractMetric<UpdateT>> ImmutableList<MetricUpdates.MetricUpdate<UpdateT>> extractUpdates(Map<MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (AbstractMetric cell : cells.values()) {
            Object value = cell.getValue();
            if (value == null) continue;
            MetricKey key = MetricKey.create((String)this.stepName, (MetricName)cell.getName());
            MetricUpdates.MetricUpdate update = MetricUpdates.MetricUpdate.create((MetricKey)key, value);
            updates.add((Object)update);
        }
        return updates.build();
    }

    private static class MetricUpdatesImpl
    extends MetricUpdates
    implements Serializable {
        private final Iterable<MetricUpdates.MetricUpdate<Long>> counters;
        private final Iterable<MetricUpdates.MetricUpdate<DistributionData>> distributions;
        private final Iterable<MetricUpdates.MetricUpdate<GaugeData>> gauges;

        MetricUpdatesImpl(Iterable<MetricUpdates.MetricUpdate<Long>> counters, Iterable<MetricUpdates.MetricUpdate<DistributionData>> distributions, Iterable<MetricUpdates.MetricUpdate<GaugeData>> gauges) {
            this.counters = counters;
            this.distributions = distributions;
            this.gauges = gauges;
        }

        public Iterable<MetricUpdates.MetricUpdate<Long>> counterUpdates() {
            return this.counters;
        }

        public Iterable<MetricUpdates.MetricUpdate<DistributionData>> distributionUpdates() {
            return this.distributions;
        }

        public Iterable<MetricUpdates.MetricUpdate<GaugeData>> gaugeUpdates() {
            return this.gauges;
        }
    }
}

