/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet.metrics;

import com.hazelcast.map.IMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MetricUpdates;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricFiltering;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JetMetricResults
extends MetricResults {
    @GuardedBy(value="this")
    private final Counters counters = new Counters();
    @GuardedBy(value="this")
    private final Distributions distributions = new Distributions();
    @GuardedBy(value="this")
    private final Gauges gauges = new Gauges();
    @GuardedBy(value="this")
    private IMap<String, MetricUpdates> metricsAccumulator;

    public JetMetricResults(IMap<String, MetricUpdates> metricsAccumulator) {
        this.metricsAccumulator = metricsAccumulator;
    }

    public synchronized void freeze() {
        this.updateLocalMetrics(this.metricsAccumulator);
        this.metricsAccumulator = null;
    }

    public synchronized MetricQueryResults queryMetrics(@Nullable MetricsFilter filter) {
        if (this.metricsAccumulator != null) {
            this.updateLocalMetrics(this.metricsAccumulator);
        }
        return new QueryResults(this.counters.filter(filter), this.distributions.filter(filter), this.gauges.filter(filter));
    }

    private synchronized void updateLocalMetrics(IMap<String, MetricUpdates> metricsAccumulator) {
        this.counters.clear();
        this.distributions.clear();
        this.gauges.clear();
        for (MetricUpdates metricUpdates : metricsAccumulator.values()) {
            this.counters.merge(metricUpdates.counterUpdates());
            this.distributions.merge(metricUpdates.distributionUpdates());
            this.gauges.merge(metricUpdates.gaugeUpdates());
        }
    }

    private static Predicate<Map.Entry<MetricKey, ?>> matchesFilter(MetricsFilter filter) {
        return entry -> MetricFiltering.matches((MetricsFilter)filter, (MetricKey)((MetricKey)entry.getKey()));
    }

    private static class Gauges {
        private final Map<MetricKey, GaugeData> gauges = new HashMap<MetricKey, GaugeData>();

        private Gauges() {
        }

        void merge(Iterable<MetricUpdates.MetricUpdate<GaugeData>> updates) {
            for (MetricUpdates.MetricUpdate<GaugeData> update : updates) {
                MetricKey key = update.getKey();
                GaugeData oldGauge = this.gauges.getOrDefault(key, GaugeData.empty());
                GaugeData updatedGauge = ((GaugeData)update.getUpdate()).combine(oldGauge);
                this.gauges.put(key, updatedGauge);
            }
        }

        void clear() {
            this.gauges.clear();
        }

        Iterable<MetricResult<GaugeResult>> filter(MetricsFilter filter) {
            return FluentIterable.from(this.gauges.entrySet()).filter(JetMetricResults.matchesFilter(filter)).transform(this::toUpdateResult).toList();
        }

        private MetricResult<GaugeResult> toUpdateResult(Map.Entry<MetricKey, GaugeData> entry) {
            MetricKey key = entry.getKey();
            GaugeResult gaugeResult = entry.getValue().extractResult();
            return MetricResult.create((MetricKey)key, (Object)gaugeResult, (Object)gaugeResult);
        }
    }

    private static class Distributions {
        private final Map<MetricKey, DistributionData> distributions = new HashMap<MetricKey, DistributionData>();

        private Distributions() {
        }

        void merge(Iterable<MetricUpdates.MetricUpdate<DistributionData>> updates) {
            for (MetricUpdates.MetricUpdate<DistributionData> update : updates) {
                MetricKey key = update.getKey();
                DistributionData oldDistribution = this.distributions.getOrDefault(key, DistributionData.EMPTY);
                DistributionData updatedDistribution = ((DistributionData)update.getUpdate()).combine(oldDistribution);
                this.distributions.put(key, updatedDistribution);
            }
        }

        void clear() {
            this.distributions.clear();
        }

        Iterable<MetricResult<DistributionResult>> filter(MetricsFilter filter) {
            return FluentIterable.from(this.distributions.entrySet()).filter(JetMetricResults.matchesFilter(filter)).transform(this::toUpdateResult).toList();
        }

        private MetricResult<DistributionResult> toUpdateResult(Map.Entry<MetricKey, DistributionData> entry) {
            MetricKey key = entry.getKey();
            DistributionResult distributionResult = entry.getValue().extractResult();
            return MetricResult.create((MetricKey)key, (Object)distributionResult, (Object)distributionResult);
        }
    }

    private static class Counters {
        private final Map<MetricKey, Long> counters = new HashMap<MetricKey, Long>();

        private Counters() {
        }

        void merge(Iterable<MetricUpdates.MetricUpdate<Long>> updates) {
            for (MetricUpdates.MetricUpdate<Long> update : updates) {
                MetricKey key = update.getKey();
                Long oldValue = this.counters.getOrDefault(key, 0L);
                Long updatedValue = oldValue + (Long)update.getUpdate();
                this.counters.put(key, updatedValue);
            }
        }

        void clear() {
            this.counters.clear();
        }

        Iterable<MetricResult<Long>> filter(MetricsFilter filter) {
            return FluentIterable.from(this.counters.entrySet()).filter(JetMetricResults.matchesFilter(filter)).transform(this::toUpdateResult).toList();
        }

        private MetricResult<Long> toUpdateResult(Map.Entry<MetricKey, Long> entry) {
            MetricKey key = entry.getKey();
            Long counter = entry.getValue();
            return MetricResult.create((MetricKey)key, (Object)counter, (Object)counter);
        }
    }

    private static class QueryResults
    extends MetricQueryResults {
        private final Iterable<MetricResult<Long>> counters;
        private final Iterable<MetricResult<DistributionResult>> distributions;
        private final Iterable<MetricResult<GaugeResult>> gauges;

        private QueryResults(Iterable<MetricResult<Long>> counters, Iterable<MetricResult<DistributionResult>> distributions, Iterable<MetricResult<GaugeResult>> gauges) {
            this.counters = counters;
            this.distributions = distributions;
            this.gauges = gauges;
        }

        public Iterable<MetricResult<Long>> getCounters() {
            return this.counters;
        }

        public Iterable<MetricResult<DistributionResult>> getDistributions() {
            return this.distributions;
        }

        public Iterable<MetricResult<GaugeResult>> getGauges() {
            return this.gauges;
        }
    }
}

