/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet;

import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.jet.JetRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Utils {
    public static String getTupleTagId(PValue value) {
        Map expansion = value.expand();
        return ((TupleTag)Iterables.getOnlyElement(expansion.keySet())).getId();
    }

    static PValue getMainInput(Pipeline pipeline, TransformHierarchy.Node node) {
        Collection<PValue> mainInputs = Utils.getMainInputs(pipeline, node);
        return mainInputs == null ? null : (PValue)Iterables.getOnlyElement(mainInputs);
    }

    static Collection<PValue> getMainInputs(Pipeline pipeline, TransformHierarchy.Node node) {
        if (node.getTransform() == null) {
            return null;
        }
        return TransformInputs.nonAdditionalInputs((AppliedPTransform)node.toAppliedPTransform(pipeline));
    }

    static Map<TupleTag<?>, PValue> getInputs(AppliedPTransform<?, ?, ?> appliedTransform) {
        return appliedTransform.getInputs();
    }

    static Map<TupleTag<?>, PValue> getAdditionalInputs(TransformHierarchy.Node node) {
        return node.getTransform() != null ? node.getTransform().getAdditionalInputs() : null;
    }

    static PValue getInput(AppliedPTransform<?, ?, ?> appliedTransform) {
        if (appliedTransform.getTransform() == null) {
            return null;
        }
        return (PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(appliedTransform));
    }

    static Map<TupleTag<?>, PValue> getOutputs(AppliedPTransform<?, ?, ?> appliedTransform) {
        if (appliedTransform.getTransform() == null) {
            return null;
        }
        return appliedTransform.getOutputs();
    }

    static Map.Entry<TupleTag<?>, PValue> getOutput(AppliedPTransform<?, ?, ?> appliedTransform) {
        return (Map.Entry)Iterables.getOnlyElement(Utils.getOutputs(appliedTransform).entrySet());
    }

    static <T> boolean isBounded(AppliedPTransform<?, ?, ?> appliedTransform) {
        return ((PCollection)Utils.getOutput(appliedTransform).getValue()).isBounded().equals((Object)PCollection.IsBounded.BOUNDED);
    }

    static boolean isKeyedValueCoder(Coder coder) {
        if (coder instanceof KvCoder) {
            return true;
        }
        if (coder instanceof WindowedValue.WindowedValueCoder) {
            return ((WindowedValue.WindowedValueCoder)coder).getValueCoder() instanceof KvCoder;
        }
        return false;
    }

    static Coder getCoder(PCollection pCollection) {
        if (pCollection.getWindowingStrategy() == null) {
            return pCollection.getCoder();
        }
        return Utils.getWindowedValueCoder(pCollection);
    }

    static <T> WindowedValue.WindowedValueCoder<T> getWindowedValueCoder(PCollection<T> pCollection) {
        return WindowedValue.FullWindowedValueCoder.of((Coder)pCollection.getCoder(), (Coder)pCollection.getWindowingStrategy().getWindowFn().windowCoder());
    }

    static <T> Map<T, Coder> getCoders(Map<TupleTag<?>, PValue> pCollections, Function<Map.Entry<TupleTag<?>, PValue>, T> tupleTagExtractor) {
        return pCollections.entrySet().stream().collect(Collectors.toMap(tupleTagExtractor, e -> Utils.getCoder((PCollection)e.getValue()), (v1, v2) -> v1));
    }

    static Map<TupleTag<?>, Coder<?>> getOutputValueCoders(AppliedPTransform<?, ?, ?> appliedTransform) {
        return appliedTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
    }

    static Collection<PCollectionView<?>> getSideInputs(AppliedPTransform<?, ?, ?> appliedTransform) {
        PTransform transform = appliedTransform.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            ParDo.MultiOutput multiParDo = (ParDo.MultiOutput)transform;
            return multiParDo.getSideInputs().values().stream().collect(Collectors.toList());
        }
        if (transform instanceof ParDo.SingleOutput) {
            ParDo.SingleOutput singleParDo = (ParDo.SingleOutput)transform;
            return singleParDo.getSideInputs().values().stream().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static boolean usesStateOrTimers(AppliedPTransform<?, ?, ?> appliedTransform) {
        try {
            return ParDoTranslation.usesStateOrTimers(appliedTransform);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static DoFn<?, ?> getDoFn(AppliedPTransform<?, ?, ?> appliedTransform) {
        try {
            DoFn doFn = ParDoTranslation.getDoFn(appliedTransform);
            if (DoFnSignatures.isSplittable((DoFn)doFn)) {
                throw new IllegalStateException("Not expected to directly translate splittable DoFn, should have been overridden: " + doFn);
            }
            if (DoFnSignatures.requiresTimeSortedInput((DoFn)doFn)) {
                throw new UnsupportedOperationException(String.format("%s doesn't currently support @RequiresTimeSortedInput annotation.", JetRunner.class.getSimpleName()));
            }
            return doFn;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static WindowingStrategy<?, ?> getWindowingStrategy(AppliedPTransform<?, ?, ?> appliedTransform) {
        Map<TupleTag<?>, PValue> outputs = Utils.getOutputs(appliedTransform);
        if (outputs == null || outputs.isEmpty()) {
            throw new IllegalStateException("No outputs defined.");
        }
        PValue taggedValue = outputs.values().iterator().next();
        Preconditions.checkState((boolean)(taggedValue instanceof PCollection), (String)"Within ParDo, got a non-PCollection output %s of type %s", (Object)taggedValue, (Object)taggedValue.getClass().getSimpleName());
        PCollection coll = (PCollection)taggedValue;
        return coll.getWindowingStrategy();
    }

    @Nonnull
    public static <T> List<T> roundRobinSubList(@Nonnull List<T> list, int index, int count) {
        if (index < 0 || index >= count) {
            throw new IllegalArgumentException("index=" + index + ", count=" + count);
        }
        return IntStream.range(0, list.size()).filter(i -> i % count == index).mapToObj(list::get).collect(Collectors.toList());
    }

    public static <T> T serde(T object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            byte[] byteData = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteData);
            return (T)new ObjectInputStream(bais).readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> byte[] encode(T value, Coder<T> coder) {
        try {
            return CoderUtils.encodeToByteArray(coder, value);
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public static <T> WindowedValue<T> decodeWindowedValue(byte[] item, Coder coder) {
        try {
            return (WindowedValue)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])item);
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public static WindowedValue.FullWindowedValueCoder deriveIterableValueCoder(WindowedValue.FullWindowedValueCoder elementCoder) {
        return WindowedValue.FullWindowedValueCoder.of((Coder)ListCoder.of((Coder)elementCoder.getValueCoder()), (Coder)elementCoder.getWindowCoder());
    }

    public static class ByteArrayKey {
        private final byte[] value;
        private int hash;

        public ByteArrayKey(@Nonnull byte[] value) {
            this.value = value;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArrayKey that = (ByteArrayKey)o;
            return Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = Arrays.hashCode(this.value);
            }
            return this.hash;
        }
    }
}

