/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet;

import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.jet.DAGBuilder;
import org.apache.beam.runners.jet.JetPipelineOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

class JetTranslationContext {
    private final SerializablePipelineOptions options;
    private final DAGBuilder dagBuilder;

    JetTranslationContext(JetPipelineOptions options) {
        this.options = new SerializablePipelineOptions((PipelineOptions)options);
        this.dagBuilder = new DAGBuilder(options);
    }

    SerializablePipelineOptions getOptions() {
        return this.options;
    }

    DAGBuilder getDagBuilder() {
        return this.dagBuilder;
    }

    <T> WindowedValue.FullWindowedValueCoder<T> getTypeInfo(PCollection<T> collection) {
        return this.getTypeInfo(collection.getCoder(), collection.getWindowingStrategy());
    }

    <T> WindowedValue.FullWindowedValueCoder<T> getTypeInfo(Coder<T> coder, WindowingStrategy<?, ?> windowingStrategy) {
        return WindowedValue.getFullCoder(coder, (Coder)windowingStrategy.getWindowFn().windowCoder());
    }
}

