/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.CreatePCollectionViewTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.ReadTranslation;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.jet.DAGBuilder;
import org.apache.beam.runners.jet.JetTransformTranslator;
import org.apache.beam.runners.jet.JetTranslationContext;
import org.apache.beam.runners.jet.Utils;
import org.apache.beam.runners.jet.processors.AbstractParDoP;
import org.apache.beam.runners.jet.processors.AssignWindowP;
import org.apache.beam.runners.jet.processors.BoundedSourceP;
import org.apache.beam.runners.jet.processors.FlattenP;
import org.apache.beam.runners.jet.processors.ImpulseP;
import org.apache.beam.runners.jet.processors.ParDoP;
import org.apache.beam.runners.jet.processors.StatefulParDoP;
import org.apache.beam.runners.jet.processors.UnboundedSourceP;
import org.apache.beam.runners.jet.processors.ViewP;
import org.apache.beam.runners.jet.processors.WindowGroupP;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

class JetTransformTranslators {
    private static final Map<String, JetTransformTranslator> TRANSLATORS = new HashMap<String, JetTransformTranslator>();

    JetTransformTranslators() {
    }

    static JetTransformTranslator<?> getTranslator(PTransform<?, ?> transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        return urn == null ? null : TRANSLATORS.get(urn);
    }

    static {
        TRANSLATORS.put("beam:transform:read:v1", new ReadSourceTranslator());
        TRANSLATORS.put("beam:transform:create_view:v1", new CreateViewTranslator());
        TRANSLATORS.put("beam:transform:pardo:v1", new ParDoTranslator());
        TRANSLATORS.put("beam:transform:group_by_key:v1", new GroupByKeyTranslator());
        TRANSLATORS.put("beam:transform:flatten:v1", new FlattenTranslator());
        TRANSLATORS.put("beam:transform:window_into:v1", new WindowTranslator());
        TRANSLATORS.put("beam:transform:impulse:v1", new ImpulseTranslator());
    }

    private static class ImpulseTranslator
    implements JetTransformTranslator<PTransform<PBegin, PCollection<byte[]>>> {
        private ImpulseTranslator() {
        }

        @Override
        public Vertex translate(Pipeline pipeline, AppliedPTransform<?, ?, ?> appliedTransform, TransformHierarchy.Node node, JetTranslationContext context) {
            String transformName = appliedTransform.getFullName();
            DAGBuilder dagBuilder = context.getDagBuilder();
            String vertexId = dagBuilder.newVertexId(transformName);
            Map.Entry<TupleTag<?>, PValue> output = Utils.getOutput(appliedTransform);
            Coder outputCoder = Utils.getCoder((PCollection)Utils.getOutput(appliedTransform).getValue());
            Vertex vertex = dagBuilder.addVertex(vertexId, ImpulseP.supplier(outputCoder, vertexId));
            String outputEdgeId = Utils.getTupleTagId(output.getValue());
            dagBuilder.registerCollectionOfEdge(outputEdgeId, output.getKey().getId());
            dagBuilder.registerEdgeStartPoint(outputEdgeId, vertex, outputCoder);
            return vertex;
        }
    }

    private static class WindowTranslator<T>
    implements JetTransformTranslator<PTransform<PCollection<T>, PCollection<T>>> {
        private WindowTranslator() {
        }

        @Override
        public Vertex translate(Pipeline pipeline, AppliedPTransform<?, ?, ?> appliedTransform, TransformHierarchy.Node node, JetTranslationContext context) {
            WindowingStrategy windowingStrategy = ((PCollection)Utils.getOutput(appliedTransform).getValue()).getWindowingStrategy();
            PCollection input = (PCollection)Utils.getInput(appliedTransform);
            Coder inputCoder = Utils.getCoder(input);
            Map.Entry<TupleTag<?>, PValue> output = Utils.getOutput(appliedTransform);
            Coder outputCoder = Utils.getCoder((PCollection)Utils.getOutput(appliedTransform).getValue());
            String transformName = appliedTransform.getFullName();
            DAGBuilder dagBuilder = context.getDagBuilder();
            String vertexId = dagBuilder.newVertexId(transformName);
            Vertex vertex = dagBuilder.addVertex(vertexId, AssignWindowP.supplier(inputCoder, outputCoder, windowingStrategy, vertexId));
            dagBuilder.registerEdgeEndPoint(Utils.getTupleTagId((PValue)input), vertex);
            String outputEdgeId = Utils.getTupleTagId(output.getValue());
            dagBuilder.registerCollectionOfEdge(outputEdgeId, output.getKey().getId());
            dagBuilder.registerEdgeStartPoint(outputEdgeId, vertex, outputCoder);
            return vertex;
        }
    }

    private static class FlattenTranslator<T>
    implements JetTransformTranslator<PTransform<PCollectionList<T>, PCollection<T>>> {
        private FlattenTranslator() {
        }

        @Override
        public Vertex translate(Pipeline pipeline, AppliedPTransform<?, ?, ?> appliedTransform, TransformHierarchy.Node node, JetTranslationContext context) {
            Collection<PValue> mainInputs = Utils.getMainInputs(pipeline, node);
            Map<String, Coder> inputCoders = Utils.getCoders(Utils.getInputs(appliedTransform), e -> Utils.getTupleTagId((PValue)e.getValue()));
            Map.Entry<TupleTag<?>, PValue> output = Utils.getOutput(appliedTransform);
            Coder outputCoder = Utils.getCoder((PCollection)output.getValue());
            DAGBuilder dagBuilder = context.getDagBuilder();
            String vertexId = dagBuilder.newVertexId(appliedTransform.getFullName());
            FlattenP.Supplier processorSupplier = new FlattenP.Supplier(inputCoders, outputCoder, vertexId);
            Vertex vertex = dagBuilder.addVertex(vertexId, processorSupplier);
            dagBuilder.registerConstructionListeners(processorSupplier);
            for (PValue value : mainInputs) {
                PCollection input = (PCollection)value;
                dagBuilder.registerEdgeEndPoint(Utils.getTupleTagId((PValue)input), vertex);
            }
            String outputEdgeId = Utils.getTupleTagId(output.getValue());
            dagBuilder.registerCollectionOfEdge(outputEdgeId, output.getKey().getId());
            dagBuilder.registerEdgeStartPoint(outputEdgeId, vertex, outputCoder);
            return vertex;
        }
    }

    private static class CreateViewTranslator<T>
    implements JetTransformTranslator<PTransform<PCollection<T>, PCollection<T>>> {
        private CreateViewTranslator() {
        }

        @Override
        public Vertex translate(Pipeline pipeline, AppliedPTransform<?, ?, ?> appliedTransform, TransformHierarchy.Node node, JetTranslationContext context) {
            PCollectionView view;
            try {
                view = CreatePCollectionViewTranslation.getView(appliedTransform);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String transformName = appliedTransform.getFullName();
            DAGBuilder dagBuilder = context.getDagBuilder();
            String vertexId = dagBuilder.newVertexId(transformName);
            PCollection input = (PCollection)Utils.getInput(appliedTransform);
            Coder inputCoder = Utils.getCoder(input);
            Map.Entry<TupleTag<?>, PValue> output = Utils.getOutput(appliedTransform);
            Coder outputCoder = Utils.getCoder((PCollection)output.getValue());
            Vertex vertex = dagBuilder.addVertex(vertexId, ViewP.supplier(inputCoder, outputCoder, input.getWindowingStrategy(), vertexId));
            dagBuilder.registerEdgeEndPoint(Utils.getTupleTagId((PValue)input), vertex);
            String viewTag = Utils.getTupleTagId((PValue)view);
            dagBuilder.registerSideInput(view);
            dagBuilder.registerCollectionOfEdge(viewTag, view.getTagInternal().getId());
            dagBuilder.registerEdgeStartPoint(viewTag, vertex, outputCoder);
            String outputEdgeId = Utils.getTupleTagId(output.getValue());
            dagBuilder.registerCollectionOfEdge(outputEdgeId, output.getKey().getId());
            dagBuilder.registerEdgeStartPoint(outputEdgeId, vertex, outputCoder);
            return vertex;
        }
    }

    private static class GroupByKeyTranslator<K, InputT>
    implements JetTransformTranslator<PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, Iterable<InputT>>>>> {
        private GroupByKeyTranslator() {
        }

        @Override
        public Vertex translate(Pipeline pipeline, AppliedPTransform<?, ?, ?> appliedTransform, TransformHierarchy.Node node, JetTranslationContext context) {
            String transformName = appliedTransform.getFullName();
            PCollection input = (PCollection)Utils.getInput(appliedTransform);
            WindowedValue.WindowedValueCoder inputCoder = Utils.getWindowedValueCoder(input);
            Map.Entry<TupleTag<?>, PValue> output = Utils.getOutput(appliedTransform);
            Coder outputCoder = Utils.getCoder((PCollection)output.getValue());
            WindowingStrategy windowingStrategy = input.getWindowingStrategy();
            DAGBuilder dagBuilder = context.getDagBuilder();
            String vertexId = dagBuilder.newVertexId(transformName);
            Vertex vertex = dagBuilder.addVertex(vertexId, WindowGroupP.supplier(context.getOptions(), inputCoder, outputCoder, windowingStrategy, vertexId));
            dagBuilder.registerEdgeEndPoint(Utils.getTupleTagId((PValue)input), vertex);
            String outputEdgeId = Utils.getTupleTagId(output.getValue());
            dagBuilder.registerCollectionOfEdge(outputEdgeId, output.getKey().getId());
            dagBuilder.registerEdgeStartPoint(outputEdgeId, vertex, outputCoder);
            return vertex;
        }
    }

    private static class ParDoTranslator
    implements JetTransformTranslator<PTransform<PCollection, PCollectionTuple>> {
        private ParDoTranslator() {
        }

        @Override
        public Vertex translate(Pipeline pipeline, AppliedPTransform<?, ?, ?> appliedTransform, TransformHierarchy.Node node, JetTranslationContext context) {
            TupleTag mainOutputTag;
            boolean usesStateOrTimers = Utils.usesStateOrTimers(appliedTransform);
            DoFn<?, ?> doFn = Utils.getDoFn(appliedTransform);
            Map<TupleTag<?>, PValue> outputs = Utils.getOutputs(appliedTransform);
            try {
                mainOutputTag = ParDoTranslation.getMainOutputTag(appliedTransform);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            HashMap outputMap = new HashMap();
            int count = 1;
            for (TupleTag<?> tag : outputs.keySet()) {
                if (outputMap.containsKey(tag)) continue;
                outputMap.put(tag, count++);
            }
            WindowingStrategy<?, ?> windowingStrategy = Utils.getWindowingStrategy(appliedTransform);
            Map<TupleTag<?>, Coder<?>> outputValueCoders = Utils.getOutputValueCoders(appliedTransform);
            Map<TupleTag<?>, Coder<?>> outputCoders = Utils.getCoders(Utils.getOutputs(appliedTransform), Map.Entry::getKey);
            String transformName = appliedTransform.getFullName();
            DAGBuilder dagBuilder = context.getDagBuilder();
            String stepId = transformName.contains("/") ? transformName.substring(0, transformName.indexOf(47)) : transformName;
            String vertexId = dagBuilder.newVertexId(transformName) + (usesStateOrTimers ? " - STATEFUL" : "");
            SerializablePipelineOptions pipelineOptions = context.getOptions();
            Coder inputValueCoder = ((PCollection)Utils.getInput(appliedTransform)).getCoder();
            Coder inputCoder = Utils.getCoder((PCollection)Utils.getInput(appliedTransform));
            Collection<PCollectionView<?>> sideInputs = Utils.getSideInputs(appliedTransform);
            Map<PCollectionView<?>, Coder<?>> sideInputCoders = sideInputs.stream().collect(Collectors.toMap(si -> si, si -> Utils.getCoder(si.getPCollection())));
            DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(appliedTransform);
            Map sideInputMappings = ParDoTranslation.getSideInputMapping(appliedTransform);
            AbstractParDoP.AbstractSupplier processorSupplier = usesStateOrTimers ? new StatefulParDoP.Supplier(stepId, vertexId, (DoFn<KV<?, ?>, ?>)doFn, windowingStrategy, doFnSchemaInformation, pipelineOptions, (TupleTag<?>)mainOutputTag, (Set<TupleTag<?>>)outputMap.keySet(), (Coder<KV<?, ?>>)inputCoder, sideInputCoders, outputCoders, (Coder<KV<?, ?>>)inputValueCoder, outputValueCoders, sideInputs, (Map<String, PCollectionView<?>>)sideInputMappings) : new ParDoP.Supplier(stepId, vertexId, doFn, windowingStrategy, doFnSchemaInformation, pipelineOptions, mainOutputTag, outputMap.keySet(), inputCoder, sideInputCoders, outputCoders, inputValueCoder, outputValueCoders, sideInputs, sideInputMappings);
            Vertex vertex = dagBuilder.addVertex(vertexId, processorSupplier);
            dagBuilder.registerConstructionListeners(processorSupplier);
            PValue mainInput = Utils.getMainInput(pipeline, node);
            dagBuilder.registerEdgeEndPoint(Utils.getTupleTagId(mainInput), vertex);
            Map<TupleTag<?>, PValue> additionalInputs = Utils.getAdditionalInputs(node);
            if (additionalInputs != null && !additionalInputs.isEmpty()) {
                for (TupleTag tupleTag : additionalInputs.keySet()) {
                    dagBuilder.registerEdgeEndPoint(tupleTag.getId(), vertex);
                }
            }
            for (Map.Entry<TupleTag<?>, PValue> entry : outputs.entrySet()) {
                TupleTag<?> pCollId = entry.getKey();
                String edgeId = Utils.getTupleTagId(entry.getValue());
                dagBuilder.registerCollectionOfEdge(edgeId, pCollId.getId());
                dagBuilder.registerEdgeStartPoint(edgeId, vertex, outputCoders.get(pCollId));
            }
            return vertex;
        }
    }

    private static class ReadSourceTranslator<T>
    implements JetTransformTranslator<PTransform<PBegin, PCollection<T>>> {
        private ReadSourceTranslator() {
        }

        @Override
        public Vertex translate(Pipeline pipeline, AppliedPTransform<?, ?, ?> appliedTransform, TransformHierarchy.Node node, JetTranslationContext context) {
            Map.Entry<TupleTag<?>, PValue> output = Utils.getOutput(appliedTransform);
            Coder outputCoder = Utils.getCoder((PCollection)Utils.getOutput(appliedTransform).getValue());
            String transformName = appliedTransform.getFullName();
            DAGBuilder dagBuilder = context.getDagBuilder();
            String vertexId = dagBuilder.newVertexId(transformName);
            SerializablePipelineOptions pipelineOptions = context.getOptions();
            ProcessorMetaSupplier processorSupplier = this.getProcessorSupplier(appliedTransform, outputCoder, vertexId, pipelineOptions);
            Vertex vertex = dagBuilder.addVertex(vertexId, processorSupplier);
            String outputEdgeId = Utils.getTupleTagId(output.getValue());
            dagBuilder.registerCollectionOfEdge(outputEdgeId, output.getKey().getId());
            dagBuilder.registerEdgeStartPoint(outputEdgeId, vertex, outputCoder);
            return vertex;
        }

        private ProcessorMetaSupplier getProcessorSupplier(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> appliedTransform, Coder outputCoder, String vertexId, SerializablePipelineOptions pipelineOptions) {
            try {
                if (Utils.isBounded(appliedTransform)) {
                    BoundedSource source = ReadTranslation.boundedSourceFromTransform(appliedTransform);
                    return BoundedSourceP.supplier(source, pipelineOptions, outputCoder, vertexId);
                }
                UnboundedSource source = ReadTranslation.unboundedSourceFromTransform(appliedTransform);
                if (source.requiresDeduping()) {
                    throw new UnsupportedOperationException("Sources requiring deduping not supported!");
                }
                return UnboundedSourceP.supplier(source, pipelineOptions, outputCoder, vertexId);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

