/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet;

import com.hazelcast.jet.Job;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.map.IMap;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.beam.runners.core.metrics.MetricUpdates;
import org.apache.beam.runners.jet.JetRunner;
import org.apache.beam.runners.jet.metrics.JetMetricResults;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetPipelineResult
implements PipelineResult {
    private static final Logger LOG = LoggerFactory.getLogger(JetRunner.class);
    private final Job job;
    private final JetMetricResults metricResults;
    private volatile PipelineResult.State terminalState;
    private CompletableFuture<Void> completionFuture;

    JetPipelineResult(@Nonnull Job job, @Nonnull IMap<String, MetricUpdates> metricsAccumulator) {
        this.job = Objects.requireNonNull(job);
        this.metricResults = new JetMetricResults(metricsAccumulator);
    }

    void setCompletionFuture(CompletableFuture<Void> completionFuture) {
        this.completionFuture = completionFuture;
    }

    void freeze(Throwable throwable) {
        this.metricResults.freeze();
        this.terminalState = throwable != null ? PipelineResult.State.FAILED : PipelineResult.State.DONE;
    }

    public PipelineResult.State getState() {
        if (this.terminalState != null) {
            return this.terminalState;
        }
        JobStatus status = this.job.getStatus();
        switch (status) {
            case COMPLETED: {
                return PipelineResult.State.DONE;
            }
            case COMPLETING: 
            case RUNNING: 
            case STARTING: {
                return PipelineResult.State.RUNNING;
            }
            case FAILED: {
                return PipelineResult.State.FAILED;
            }
            case NOT_RUNNING: 
            case SUSPENDED: 
            case SUSPENDED_EXPORTING_SNAPSHOT: {
                return PipelineResult.State.STOPPED;
            }
        }
        LOG.warn("Unhandled " + JobStatus.class.getSimpleName() + ": " + status.name() + "!");
        return PipelineResult.State.UNKNOWN;
    }

    public PipelineResult.State cancel() throws IOException {
        if (this.terminalState != null) {
            throw new IllegalStateException("Job already completed");
        }
        try {
            this.job.cancel();
            this.job.join();
        }
        catch (CancellationException cancellationException) {
        }
        catch (Exception e) {
            throw new IOException("Failed to cancel the job: " + e, e);
        }
        return PipelineResult.State.FAILED;
    }

    public PipelineResult.State waitUntilFinish(Duration duration) {
        if (this.terminalState != null) {
            return this.terminalState;
        }
        try {
            this.completionFuture.get(duration.getMillis(), TimeUnit.MILLISECONDS);
            return PipelineResult.State.DONE;
        }
        catch (InterruptedException | TimeoutException e) {
            return this.getState();
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
    }

    public PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(new Duration(Long.MAX_VALUE));
    }

    public MetricResults metrics() {
        return this.metricResults;
    }
}

