/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;

public interface JetPipelineOptions
extends PipelineOptions {
    @Description(value="Name of Jet group")
    @Validation.Required
    @Default.String(value="jet")
    public String getClusterName();

    public void setClusterName(String var1);

    @Description(value="Specifies the addresses of the Jet cluster; needed only with external clusters")
    @Validation.Required
    @Default.String(value="127.0.0.1:5701")
    public String getJetServers();

    public void setJetServers(String var1);

    @Description(value="Specifies where the fat-jar containing all the code is located; needed only with external clusters")
    public String getCodeJarPathname();

    public void setCodeJarPathname(String var1);

    @Description(value="Local parallelism of Jet nodes")
    @Validation.Required
    @Default.Integer(value=2)
    public Integer getJetDefaultParallelism();

    public void setJetDefaultParallelism(Integer var1);

    @Description(value="Number of locally started Jet Cluster Members")
    @Validation.Required
    @Default.Integer(value=0)
    public Integer getJetLocalMode();

    public void setJetLocalMode(Integer var1);

    @Description(value="Weather Jet Processors for DoFns should use green threads or not")
    @Validation.Required
    @Default.Boolean(value=false)
    public Boolean getJetProcessorsCooperative();

    public void setJetProcessorsCooperative(Boolean var1);
}

