/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet;

import com.hazelcast.jet.core.DAG;
import java.util.function.Function;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.jet.JetPipelineOptions;
import org.apache.beam.runners.jet.JetTransformTranslator;
import org.apache.beam.runners.jet.JetTranslationContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;

class JetGraphVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private final JetTranslationContext translationContext;
    private final Function<PTransform<?, ?>, JetTransformTranslator<?>> translatorProvider;
    private boolean finalized = false;

    JetGraphVisitor(JetPipelineOptions options, Function<PTransform<?, ?>, JetTransformTranslator<?>> translatorProvider) {
        this.translationContext = new JetTranslationContext(options);
        this.translatorProvider = translatorProvider;
    }

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        JetTransformTranslator<?> translator;
        if (this.finalized) {
            throw new IllegalStateException("Attempting to traverse an already finalized pipeline!");
        }
        PTransform transform = node.getTransform();
        if (transform != null && (translator = this.translatorProvider.apply(transform)) != null) {
            this.translate(node, translator);
            return Pipeline.PipelineVisitor.CompositeBehavior.DO_NOT_ENTER_TRANSFORM;
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void leaveCompositeTransform(TransformHierarchy.Node node) {
        if (this.finalized) {
            throw new IllegalStateException("Attempting to traverse an already finalized pipeline!");
        }
        if (node.isRootNode()) {
            this.finalized = true;
        }
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        PTransform transform = node.getTransform();
        JetTransformTranslator<?> translator = this.translatorProvider.apply(transform);
        if (translator == null) {
            String transformUrn = PTransformTranslation.urnForTransform((PTransform)transform);
            throw new UnsupportedOperationException("The transform " + transformUrn + " is currently not supported.");
        }
        this.translate(node, translator);
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
    }

    DAG getDAG() {
        return this.translationContext.getDagBuilder().getDag();
    }

    private <T extends PTransform<?, ?>> void translate(TransformHierarchy.Node node, JetTransformTranslator<?> translator) {
        JetTransformTranslator<?> typedTranslator = translator;
        Pipeline pipeline = this.getPipeline();
        AppliedPTransform appliedTransform = node.toAppliedPTransform(pipeline);
        typedTranslator.translate(pipeline, appliedTransform, node, this.translationContext);
    }
}

