/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.jet;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.runners.jet.JetPipelineOptions;
import org.apache.beam.runners.jet.Utils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;

public class DAGBuilder {
    private final DAG dag = new DAG();
    private final int localParallelism;
    private final Map<String, Vertex> edgeStartPoints = new HashMap<String, Vertex>();
    private final Map<String, List<Vertex>> edgeEndPoints = new HashMap<String, List<Vertex>>();
    private final Map<String, Coder> edgeCoders = new HashMap<String, Coder>();
    private final Map<String, String> pCollsOfEdges = new HashMap<String, String>();
    private final Set<String> sideInputCollections = new HashSet<String>();
    private final List<WiringListener> listeners = new ArrayList<WiringListener>();
    private int vertexId = 0;

    DAGBuilder(JetPipelineOptions options) {
        this.localParallelism = options.getJetDefaultParallelism();
    }

    DAG getDag() {
        this.wireUp();
        return this.dag;
    }

    void registerConstructionListeners(WiringListener listener) {
        this.listeners.add(listener);
    }

    String newVertexId(String transformName) {
        return this.vertexId++ + " (" + transformName + ")";
    }

    void registerCollectionOfEdge(String edgeId, String pCollId) {
        String prevPCollId = this.pCollsOfEdges.put(edgeId, pCollId);
        if (prevPCollId != null) {
            throw new RuntimeException("Oops!");
        }
    }

    void registerEdgeStartPoint(String edgeId, Vertex vertex, Coder coder) {
        Objects.requireNonNull(edgeId);
        Objects.requireNonNull(vertex);
        Objects.requireNonNull(coder);
        Vertex prevVertex = this.edgeStartPoints.put(edgeId, vertex);
        if (prevVertex != null) {
            throw new RuntimeException("Oops!");
        }
        Coder prevCoder = this.edgeCoders.put(edgeId, coder);
        if (prevCoder != null) {
            throw new RuntimeException("Oops!");
        }
    }

    void registerEdgeEndPoint(String edgeId, Vertex vertex) {
        this.edgeEndPoints.computeIfAbsent(edgeId, x -> new ArrayList()).add(vertex);
    }

    void registerSideInput(PCollectionView<?> view) {
        this.sideInputCollections.add(view.getTagInternal().getId());
    }

    Vertex addVertex(String id, ProcessorMetaSupplier processorMetaSupplier) {
        return this.dag.newVertex(id, processorMetaSupplier);
    }

    Vertex addVertex(String id, SupplierEx<Processor> processor) {
        return this.dag.newVertex(id, processor).localParallelism(this.localParallelism);
    }

    private void wireUp() {
        new WiringInstaller().wireUp();
    }

    private static class PartitionedKeyExtractor<K, V>
    implements FunctionEx<byte[], Object> {
        private final WindowedValue.WindowedValueCoder<KV<K, V>> coder;

        PartitionedKeyExtractor(Coder coder) {
            this.coder = Utils.isKeyedValueCoder(coder) ? (WindowedValue.WindowedValueCoder)coder : null;
        }

        public Object applyEx(byte[] b) throws Exception {
            if (this.coder == null) {
                return "ALL";
            }
            WindowedValue windowedValue = (WindowedValue)CoderUtils.decodeFromByteArray(this.coder, (byte[])b);
            KvCoder kvCoder = (KvCoder)this.coder.getValueCoder();
            return CoderUtils.encodeToByteArray((Coder)kvCoder.getKeyCoder(), (Object)((KV)windowedValue.getValue()).getKey());
        }
    }

    private class WiringInstaller {
        private final Map<Vertex, Integer> inboundOrdinals = new HashMap<Vertex, Integer>();
        private final Map<Vertex, Integer> outboundOrdinals = new HashMap<Vertex, Integer>();

        private WiringInstaller() {
        }

        void wireUp() {
            HashSet edgeIds = new HashSet();
            edgeIds.addAll(DAGBuilder.this.edgeStartPoints.keySet());
            edgeIds.addAll(DAGBuilder.this.edgeEndPoints.keySet());
            for (String edgeId : edgeIds) {
                String pCollId = (String)DAGBuilder.this.pCollsOfEdges.get(edgeId);
                if (pCollId == null) {
                    throw new RuntimeException("Oops!");
                }
                Vertex sourceVertex = (Vertex)DAGBuilder.this.edgeStartPoints.get(edgeId);
                if (sourceVertex == null) {
                    throw new RuntimeException("Oops!");
                }
                Coder edgeCoder = (Coder)DAGBuilder.this.edgeCoders.get(edgeId);
                if (edgeCoder == null) {
                    throw new RuntimeException("Oops!");
                }
                List destinationVertices = DAGBuilder.this.edgeEndPoints.getOrDefault(edgeId, Collections.emptyList());
                boolean sideInputEdge = DAGBuilder.this.sideInputCollections.contains(pCollId);
                for (Vertex destinationVertex : destinationVertices) {
                    this.addEdge(sourceVertex, destinationVertex, edgeCoder, edgeId, pCollId, sideInputEdge);
                }
            }
        }

        private void addEdge(Vertex sourceVertex, Vertex destinationVertex, Coder coder, String edgeId, String pCollId, boolean sideInputEdge) {
            try {
                Edge edge = Edge.from((Vertex)sourceVertex, (int)this.getNextFreeOrdinal(sourceVertex, false)).to(destinationVertex, this.getNextFreeOrdinal(destinationVertex, true));
                edge = edge.distributed();
                edge = sideInputEdge ? edge.broadcast() : edge.partitioned(new PartitionedKeyExtractor(coder));
                DAGBuilder.this.dag.edge(edge);
                String sourceVertexName = sourceVertex.getName();
                String destinationVertexName = destinationVertex.getName();
                for (WiringListener listener : DAGBuilder.this.listeners) {
                    listener.isInboundEdgeOfVertex(edge, edgeId, pCollId, destinationVertexName);
                    listener.isOutboundEdgeOfVertex(edge, edgeId, pCollId, sourceVertexName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private int getNextFreeOrdinal(Vertex vertex, boolean inbound) {
            Map<Vertex, Integer> ordinals = inbound ? this.inboundOrdinals : this.outboundOrdinals;
            int nextOrdinal = 1 + ordinals.getOrDefault(vertex, -1);
            ordinals.put(vertex, nextOrdinal);
            return nextOrdinal;
        }
    }

    public static interface WiringListener {
        public void isOutboundEdgeOfVertex(Edge var1, String var2, String var3, String var4);

        public void isInboundEdgeOfVertex(Edge var1, String var2, String var3, String var4);
    }
}

