/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import org.apache.beam.runners.dataflow.util.TimeUtil;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class TimeUtilTest {
    @Test
    public void toCloudTimeShouldPrintTimeStrings() {
        Assert.assertEquals((Object)"1970-01-01T00:00:00Z", (Object)TimeUtil.toCloudTime((ReadableInstant)new Instant(0L)));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.001Z", (Object)TimeUtil.toCloudTime((ReadableInstant)new Instant(1L)));
    }

    @Test
    public void fromCloudTimeShouldParseTimeStrings() {
        Assert.assertEquals((Object)new Instant(0L), (Object)TimeUtil.fromCloudTime((String)"1970-01-01T00:00:00Z"));
        Assert.assertEquals((Object)new Instant(1L), (Object)TimeUtil.fromCloudTime((String)"1970-01-01T00:00:00.001Z"));
        Assert.assertEquals((Object)new Instant(1L), (Object)TimeUtil.fromCloudTime((String)"1970-01-01T00:00:00.001000Z"));
        Assert.assertEquals((Object)new Instant(1L), (Object)TimeUtil.fromCloudTime((String)"1970-01-01T00:00:00.001001Z"));
        Assert.assertEquals((Object)new Instant(1L), (Object)TimeUtil.fromCloudTime((String)"1970-01-01T00:00:00.001000000Z"));
        Assert.assertEquals((Object)new Instant(1L), (Object)TimeUtil.fromCloudTime((String)"1970-01-01T00:00:00.001000001Z"));
        Assert.assertNull((Object)TimeUtil.fromCloudTime((String)""));
        Assert.assertNull((Object)TimeUtil.fromCloudTime((String)"1970-01-01T00:00:00"));
    }

    @Test
    public void toCloudDurationShouldPrintDurationStrings() {
        Assert.assertEquals((Object)"0s", (Object)TimeUtil.toCloudDuration((ReadableDuration)Duration.ZERO));
        Assert.assertEquals((Object)"4s", (Object)TimeUtil.toCloudDuration((ReadableDuration)Duration.millis((long)4000L)));
        Assert.assertEquals((Object)"4.001s", (Object)TimeUtil.toCloudDuration((ReadableDuration)Duration.millis((long)4001L)));
    }

    @Test
    public void fromCloudDurationShouldParseDurationStrings() {
        Assert.assertEquals((Object)Duration.millis((long)4000L), (Object)TimeUtil.fromCloudDuration((String)"4s"));
        Assert.assertEquals((Object)Duration.millis((long)4001L), (Object)TimeUtil.fromCloudDuration((String)"4.001s"));
        Assert.assertEquals((Object)Duration.millis((long)4001L), (Object)TimeUtil.fromCloudDuration((String)"4.001000s"));
        Assert.assertEquals((Object)Duration.millis((long)4001L), (Object)TimeUtil.fromCloudDuration((String)"4.001001s"));
        Assert.assertEquals((Object)Duration.millis((long)4001L), (Object)TimeUtil.fromCloudDuration((String)"4.001000000s"));
        Assert.assertEquals((Object)Duration.millis((long)4001L), (Object)TimeUtil.fromCloudDuration((String)"4.001000001s"));
        Assert.assertNull((Object)TimeUtil.fromCloudDuration((String)""));
        Assert.assertNull((Object)TimeUtil.fromCloudDuration((String)"4"));
        Assert.assertNull((Object)TimeUtil.fromCloudDuration((String)"4.1"));
        Assert.assertNull((Object)TimeUtil.fromCloudDuration((String)"4.1s"));
    }
}

