/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Sleeper;
import com.google.api.services.dataflow.model.DataflowPackage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.beam.runners.dataflow.util.PackageUtil;
import org.apache.beam.sdk.options.GcsOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.repackaged.com.google.common.collect.Lists;
import org.apache.beam.sdk.repackaged.com.google.common.io.Files;
import org.apache.beam.sdk.repackaged.com.google.common.io.LineReader;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.FastNanoClockAndSleeper;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.IOChannelUtils;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class PackageUtilTest {
    @Rule
    public ExpectedLogs logged = ExpectedLogs.none(PackageUtil.class);
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public FastNanoClockAndSleeper fastNanoClockAndSleeper = new FastNanoClockAndSleeper();
    @Mock
    GcsUtil mockGcsUtil;
    private static final String HASH_PATTERN = "[a-zA-Z0-9+-]{22}";
    static final String STAGING_PATH = GcsPath.fromComponents((String)"somebucket", (String)"base/path").toString();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        GcsOptions pipelineOptions = (GcsOptions)PipelineOptionsFactory.as(GcsOptions.class);
        pipelineOptions.setGcsUtil(this.mockGcsUtil);
        IOChannelUtils.registerStandardIOFactories((PipelineOptions)pipelineOptions);
    }

    private File makeFileWithContents(String name, String contents) throws Exception {
        File tmpFile = this.tmpFolder.newFile(name);
        Files.write((CharSequence)contents, (File)tmpFile, (Charset)StandardCharsets.UTF_8);
        tmpFile.setLastModified(0L);
        return tmpFile;
    }

    private static PackageUtil.PackageAttributes makePackageAttributes(File file, String overridePackageName) {
        return PackageUtil.createPackageAttributes((File)file, (String)STAGING_PATH, (String)overridePackageName);
    }

    @Test
    public void testFileWithExtensionPackageNamingAndSize() throws Exception {
        String contents = "This is a test!";
        File tmpFile = this.makeFileWithContents("file.txt", contents);
        PackageUtil.PackageAttributes attr = PackageUtilTest.makePackageAttributes(tmpFile, null);
        DataflowPackage target = attr.getDataflowPackage();
        Assert.assertThat((Object)target.getName(), (Matcher)RegexMatcher.matches("file-[a-zA-Z0-9+-]{22}.txt"));
        Assert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + '/' + target.getName())));
        Assert.assertThat((Object)attr.getSize(), (Matcher)org.hamcrest.Matchers.equalTo((Object)contents.length()));
    }

    @Test
    public void testPackageNamingWithFileNoExtension() throws Exception {
        File tmpFile = this.makeFileWithContents("file", "This is a test!");
        DataflowPackage target = PackageUtilTest.makePackageAttributes(tmpFile, null).getDataflowPackage();
        Assert.assertThat((Object)target.getName(), (Matcher)RegexMatcher.matches("file-[a-zA-Z0-9+-]{22}"));
        Assert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + '/' + target.getName())));
    }

    @Test
    public void testPackageNamingWithDirectory() throws Exception {
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        DataflowPackage target = PackageUtilTest.makePackageAttributes(tmpDirectory, null).getDataflowPackage();
        Assert.assertThat((Object)target.getName(), (Matcher)RegexMatcher.matches("folder-[a-zA-Z0-9+-]{22}.jar"));
        Assert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + '/' + target.getName())));
    }

    @Test
    public void testPackageNamingWithFilesHavingSameContentsAndSameNames() throws Exception {
        File tmpDirectory1 = this.tmpFolder.newFolder(new String[]{"folder1", "folderA"});
        this.makeFileWithContents("folder1/folderA/sameName", "This is a test!");
        DataflowPackage target1 = PackageUtilTest.makePackageAttributes(tmpDirectory1, null).getDataflowPackage();
        File tmpDirectory2 = this.tmpFolder.newFolder(new String[]{"folder2", "folderA"});
        this.makeFileWithContents("folder2/folderA/sameName", "This is a test!");
        DataflowPackage target2 = PackageUtilTest.makePackageAttributes(tmpDirectory2, null).getDataflowPackage();
        Assert.assertEquals((Object)target1.getName(), (Object)target2.getName());
        Assert.assertEquals((Object)target1.getLocation(), (Object)target2.getLocation());
    }

    @Test
    public void testPackageNamingWithFilesHavingSameContentsButDifferentNames() throws Exception {
        File tmpDirectory1 = this.tmpFolder.newFolder(new String[]{"folder1", "folderA"});
        this.makeFileWithContents("folder1/folderA/uniqueName1", "This is a test!");
        DataflowPackage target1 = PackageUtilTest.makePackageAttributes(tmpDirectory1, null).getDataflowPackage();
        File tmpDirectory2 = this.tmpFolder.newFolder(new String[]{"folder2", "folderA"});
        this.makeFileWithContents("folder2/folderA/uniqueName2", "This is a test!");
        DataflowPackage target2 = PackageUtilTest.makePackageAttributes(tmpDirectory2, null).getDataflowPackage();
        Assert.assertNotEquals((Object)target1.getName(), (Object)target2.getName());
        Assert.assertNotEquals((Object)target1.getLocation(), (Object)target2.getLocation());
    }

    @Test
    public void testPackageNamingWithDirectoriesHavingSameContentsButDifferentNames() throws Exception {
        File tmpDirectory1 = this.tmpFolder.newFolder(new String[]{"folder1", "folderA"});
        this.tmpFolder.newFolder(new String[]{"folder1", "folderA", "uniqueName1"});
        DataflowPackage target1 = PackageUtilTest.makePackageAttributes(tmpDirectory1, null).getDataflowPackage();
        File tmpDirectory2 = this.tmpFolder.newFolder(new String[]{"folder2", "folderA"});
        this.tmpFolder.newFolder(new String[]{"folder2", "folderA", "uniqueName2"});
        DataflowPackage target2 = PackageUtilTest.makePackageAttributes(tmpDirectory2, null).getDataflowPackage();
        Assert.assertNotEquals((Object)target1.getName(), (Object)target2.getName());
        Assert.assertNotEquals((Object)target1.getLocation(), (Object)target2.getLocation());
    }

    @Test
    public void testPackageUploadWithLargeClasspathLogsWarning() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenReturn((Object)tmpFile.length());
        LinkedList classpathElements = Lists.newLinkedList();
        for (int i = 0; i < 1005; ++i) {
            String eltName = "element" + i;
            classpathElements.add(eltName + '=' + tmpFile.getAbsolutePath());
        }
        PackageUtil.stageClasspathElements((Collection)classpathElements, (String)STAGING_PATH);
        this.logged.verifyWarn("Your classpath contains 1005 elements, which Google Cloud Dataflow");
    }

    @Test
    public void testPackageUploadWithFileSucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        String contents = "This is a test!";
        File tmpFile = this.makeFileWithContents("file.txt", contents);
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenThrow(new Throwable[]{new FileNotFoundException("some/path")});
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenReturn((Object)pipe.sink());
        List targets = PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpFile.getAbsolutePath()), (String)STAGING_PATH);
        DataflowPackage target = (DataflowPackage)Iterables.getOnlyElement((Iterable)targets);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        Assert.assertThat((Object)target.getName(), (Matcher)RegexMatcher.matches("file-[a-zA-Z0-9+-]{22}.txt"));
        Assert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + '/' + target.getName())));
        Assert.assertThat((Object)new LineReader((Readable)Channels.newReader((ReadableByteChannel)pipe.source(), "UTF-8")).readLine(), (Matcher)org.hamcrest.Matchers.equalTo((Object)contents));
    }

    @Test
    public void testPackageUploadWithDirectorySucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        this.tmpFolder.newFolder(new String[]{"folder", "empty_directory"});
        this.tmpFolder.newFolder(new String[]{"folder", "directory"});
        this.makeFileWithContents("folder/file.txt", "This is a test!");
        this.makeFileWithContents("folder/directory/file.txt", "This is also a test!");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenThrow(new Throwable[]{new FileNotFoundException("some/path")});
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenReturn((Object)pipe.sink());
        PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpDirectory.getAbsolutePath()), (String)STAGING_PATH);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        ZipInputStream inputStream = new ZipInputStream(Channels.newInputStream(pipe.source()));
        ArrayList<String> zipEntryNames = new ArrayList<String>();
        ZipEntry entry = inputStream.getNextEntry();
        while (entry != null) {
            zipEntryNames.add(entry.getName());
            entry = inputStream.getNextEntry();
        }
        Assert.assertThat(zipEntryNames, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"directory/file.txt", "empty_directory/", "file.txt"}));
    }

    @Test
    public void testPackageUploadWithEmptyDirectorySucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenThrow(new Throwable[]{new FileNotFoundException("some/path")});
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenReturn((Object)pipe.sink());
        List targets = PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpDirectory.getAbsolutePath()), (String)STAGING_PATH);
        DataflowPackage target = (DataflowPackage)Iterables.getOnlyElement((Iterable)targets);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        Assert.assertThat((Object)target.getName(), (Matcher)RegexMatcher.matches("folder-[a-zA-Z0-9+-]{22}.jar"));
        Assert.assertThat((Object)target.getLocation(), (Matcher)org.hamcrest.Matchers.equalTo((Object)(STAGING_PATH + '/' + target.getName())));
        Assert.assertNull((Object)new ZipInputStream(Channels.newInputStream(pipe.source())).getNextEntry());
    }

    @Test(expected=RuntimeException.class)
    public void testPackageUploadFailsWhenIOExceptionThrown() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenThrow(new Throwable[]{new FileNotFoundException("some/path")});
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenThrow(new Throwable[]{new IOException("Fake Exception: Upload error")});
        try {
            PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpFile.getAbsolutePath()), (String)STAGING_PATH, (Sleeper)this.fastNanoClockAndSleeper);
        }
        catch (Throwable throwable) {
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)5))).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
            throw throwable;
        }
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)5))).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadFailsWithPermissionsErrorGivesDetailedMessage() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenThrow(new Throwable[]{new FileNotFoundException("some/path")});
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenThrow(new Throwable[]{new IOException("Failed to write to GCS path " + STAGING_PATH, (Throwable)PackageUtilTest.googleJsonResponseException(403, "Permission denied", "Test message"))});
        try {
            PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpFile.getAbsolutePath()), (String)STAGING_PATH, (Sleeper)this.fastNanoClockAndSleeper);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException e) {
            try {
                Assert.assertTrue((String)"Expected IOException containing detailed message.", (boolean)(e.getCause() instanceof IOException));
                Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"Uploaded failed due to permissions error"), (Matcher)org.hamcrest.Matchers.containsString((String)"Stale credentials can be resolved by executing 'gcloud auth login'")));
            }
            catch (Throwable throwable) {
                ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
                ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
                throw throwable;
            }
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        }
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadEventuallySucceeds() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenThrow(new Throwable[]{new FileNotFoundException("some/path")});
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenThrow(new Throwable[]{new IOException("Fake Exception: 410 Gone")}).thenReturn((Object)pipe.sink());
        try {
            PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpFile.getAbsolutePath()), (String)STAGING_PATH, (Sleeper)this.fastNanoClockAndSleeper);
        }
        catch (Throwable throwable) {
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
            ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)2))).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
            throw throwable;
        }
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil, (VerificationMode)Mockito.times((int)2))).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadIsSkippedWhenFileAlreadyExists() throws Exception {
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenReturn((Object)tmpFile.length());
        PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpFile.getAbsolutePath()), (String)STAGING_PATH);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadIsNotSkippedWhenSizesAreDifferent() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpDirectory = this.tmpFolder.newFolder("folder");
        this.tmpFolder.newFolder(new String[]{"folder", "empty_directory"});
        this.tmpFolder.newFolder(new String[]{"folder", "directory"});
        this.makeFileWithContents("folder/file.txt", "This is a test!");
        this.makeFileWithContents("folder/directory/file.txt", "This is also a test!");
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenReturn((Object)Long.MAX_VALUE);
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenReturn((Object)pipe.sink());
        PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)tmpDirectory.getAbsolutePath()), (String)STAGING_PATH);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
    }

    @Test
    public void testPackageUploadWithExplicitPackageName() throws Exception {
        Pipe pipe = Pipe.open();
        File tmpFile = this.makeFileWithContents("file.txt", "This is a test!");
        String overriddenName = "alias.txt";
        Mockito.when((Object)this.mockGcsUtil.fileSize((GcsPath)Matchers.any(GcsPath.class))).thenThrow(new Throwable[]{new FileNotFoundException("some/path")});
        Mockito.when((Object)this.mockGcsUtil.create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString())).thenReturn((Object)pipe.sink());
        List targets = PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)("alias.txt=" + tmpFile.getAbsolutePath())), (String)STAGING_PATH);
        DataflowPackage target = (DataflowPackage)Iterables.getOnlyElement((Iterable)targets);
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).fileSize((GcsPath)Matchers.any(GcsPath.class));
        ((GcsUtil)Mockito.verify((Object)this.mockGcsUtil)).create((GcsPath)Matchers.any(GcsPath.class), Matchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsUtil});
        Assert.assertThat((Object)target.getName(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"alias.txt"));
        Assert.assertThat((Object)target.getLocation(), (Matcher)RegexMatcher.matches(STAGING_PATH + "/file-" + HASH_PATTERN + ".txt"));
    }

    @Test
    public void testPackageUploadIsSkippedWithNonExistentResource() throws Exception {
        String nonExistentFile = IOChannelUtils.resolve((String)this.tmpFolder.getRoot().getPath(), (String[])new String[]{"non-existent-file"});
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)PackageUtil.stageClasspathElements((Collection)ImmutableList.of((Object)nonExistentFile), (String)STAGING_PATH));
    }

    private static GoogleJsonResponseException googleJsonResponseException(int status, final String reason, final String message) throws IOException {
        JacksonFactory jsonFactory = new JacksonFactory();
        MockHttpTransport transport = new MockHttpTransport((JsonFactory)jsonFactory, status){
            final /* synthetic */ JsonFactory val$jsonFactory;
            final /* synthetic */ int val$status;
            {
                this.val$jsonFactory = jsonFactory;
                this.val$status = n;
            }

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                GoogleJsonError.ErrorInfo errorInfo = new GoogleJsonError.ErrorInfo();
                errorInfo.setReason(reason);
                errorInfo.setMessage(message);
                errorInfo.setFactory(this.val$jsonFactory);
                GenericJson error = new GenericJson();
                error.set("code", (Object)this.val$status);
                error.set("errors", Arrays.asList(errorInfo));
                error.setFactory(this.val$jsonFactory);
                GenericJson errorResponse = new GenericJson();
                errorResponse.set("error", (Object)error);
                errorResponse.setFactory(this.val$jsonFactory);
                return new MockLowLevelHttpRequest().setResponse(new MockLowLevelHttpResponse().setContent(errorResponse.toPrettyString()).setContentType("application/json; charset=UTF-8").setStatusCode(this.val$status));
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        return GoogleJsonResponseException.from((JsonFactory)jsonFactory, (HttpResponse)response);
    }

    private static class RegexMatcher
    extends BaseMatcher<String> {
        private final Pattern pattern;

        public RegexMatcher(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public boolean matches(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            return this.pattern.matcher((String)o).matches();
        }

        public void describeTo(Description description) {
            description.appendText(String.format("matches regular expression %s", this.pattern));
        }

        public static RegexMatcher matches(String regex) {
            return new RegexMatcher(regex);
        }
    }
}

