/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.JobMessage;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.runners.dataflow.util.TimeUtil;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.util.TestCredential;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MonitoringUtilTest {
    private static final String PROJECT_ID = "someProject";
    private static final String JOB_ID = "1234";
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(MonitoringUtil.LoggingHandler.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testGetJobMessages() throws IOException {
        Dataflow.Projects.Jobs.Messages mockMessages = (Dataflow.Projects.Jobs.Messages)Mockito.mock(Dataflow.Projects.Jobs.Messages.class);
        Dataflow.Projects.Jobs.Messages.List firstRequest = (Dataflow.Projects.Jobs.Messages.List)Mockito.mock(Dataflow.Projects.Jobs.Messages.List.class);
        Dataflow.Projects.Jobs.Messages.List secondRequest = (Dataflow.Projects.Jobs.Messages.List)Mockito.mock(Dataflow.Projects.Jobs.Messages.List.class);
        Mockito.when((Object)mockMessages.list(PROJECT_ID, JOB_ID)).thenReturn((Object)firstRequest).thenReturn((Object)secondRequest);
        ListJobMessagesResponse firstResponse = new ListJobMessagesResponse();
        firstResponse.setJobMessages(new ArrayList());
        for (int i = 0; i < 100; ++i) {
            JobMessage message = new JobMessage();
            message.setId("message_" + i);
            message.setTime(TimeUtil.toCloudTime((ReadableInstant)new Instant((long)i)));
            firstResponse.getJobMessages().add(message);
        }
        String pageToken = "page_token";
        firstResponse.setNextPageToken(pageToken);
        ListJobMessagesResponse secondResponse = new ListJobMessagesResponse();
        secondResponse.setJobMessages(new ArrayList());
        for (int i = 100; i < 150; ++i) {
            JobMessage message = new JobMessage();
            message.setId("message_" + i);
            message.setTime(TimeUtil.toCloudTime((ReadableInstant)new Instant((long)i)));
            secondResponse.getJobMessages().add(message);
        }
        Mockito.when((Object)firstRequest.execute()).thenReturn((Object)firstResponse);
        Mockito.when((Object)secondRequest.execute()).thenReturn((Object)secondResponse);
        MonitoringUtil util = new MonitoringUtil(PROJECT_ID, mockMessages);
        ArrayList messages = util.getJobMessages(JOB_ID, -1L);
        ((Dataflow.Projects.Jobs.Messages.List)Mockito.verify((Object)secondRequest)).setPageToken(pageToken);
        Assert.assertEquals((long)150L, (long)messages.size());
    }

    @Test
    public void testToStateCreatesState() {
        String stateName = "JOB_STATE_DONE";
        PipelineResult.State result = MonitoringUtil.toState((String)stateName);
        Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)result);
    }

    @Test
    public void testToStateWithNullReturnsUnknown() {
        String stateName = null;
        PipelineResult.State result = MonitoringUtil.toState(stateName);
        Assert.assertEquals((Object)PipelineResult.State.UNKNOWN, (Object)result);
    }

    @Test
    public void testToStateWithOtherValueReturnsUnknown() {
        String stateName = "FOO_BAR_BAZ";
        PipelineResult.State result = MonitoringUtil.toState((String)stateName);
        Assert.assertEquals((Object)PipelineResult.State.UNKNOWN, (Object)result);
    }

    @Test
    public void testDontOverrideEndpointWithDefaultApi() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setProject(PROJECT_ID);
        options.setGcpCredential((Credential)new TestCredential());
        String cancelCommand = MonitoringUtil.getGcloudCancelCommand((DataflowPipelineOptions)options, (String)JOB_ID);
        Assert.assertEquals((Object)"gcloud alpha dataflow jobs --project=someProject cancel 1234", (Object)cancelCommand);
    }

    @Test
    public void testOverridesEndpointWithStagedDataflowEndpoint() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setProject(PROJECT_ID);
        options.setGcpCredential((Credential)new TestCredential());
        String stagingDataflowEndpoint = "v0neverExisted";
        options.setDataflowEndpoint(stagingDataflowEndpoint);
        String cancelCommand = MonitoringUtil.getGcloudCancelCommand((DataflowPipelineOptions)options, (String)JOB_ID);
        Assert.assertEquals((Object)"CLOUDSDK_API_ENDPOINT_OVERRIDES_DATAFLOW=https://dataflow.googleapis.com/v0neverExisted/ gcloud alpha dataflow jobs --project=someProject cancel 1234", (Object)cancelCommand);
    }

    @Test
    public void testLoggingHandler() {
        DateTime errorTime = new DateTime(1000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime warningTime = new DateTime(2000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime basicTime = new DateTime(3000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime detailedTime = new DateTime(4000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime debugTime = new DateTime(5000L, (Chronology)ISOChronology.getInstanceUTC());
        DateTime unknownTime = new DateTime(6000L, (Chronology)ISOChronology.getInstanceUTC());
        JobMessage errorJobMessage = new JobMessage();
        errorJobMessage.setMessageImportance("JOB_MESSAGE_ERROR");
        errorJobMessage.setMessageText("ERRORERROR");
        errorJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)errorTime));
        JobMessage warningJobMessage = new JobMessage();
        warningJobMessage.setMessageImportance("JOB_MESSAGE_WARNING");
        warningJobMessage.setMessageText("WARNINGWARNING");
        warningJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)warningTime));
        JobMessage basicJobMessage = new JobMessage();
        basicJobMessage.setMessageImportance("JOB_MESSAGE_BASIC");
        basicJobMessage.setMessageText("BASICBASIC");
        basicJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)basicTime));
        JobMessage detailedJobMessage = new JobMessage();
        detailedJobMessage.setMessageImportance("JOB_MESSAGE_DETAILED");
        detailedJobMessage.setMessageText("DETAILEDDETAILED");
        detailedJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)detailedTime));
        JobMessage debugJobMessage = new JobMessage();
        debugJobMessage.setMessageImportance("JOB_MESSAGE_DEBUG");
        debugJobMessage.setMessageText("DEBUGDEBUG");
        debugJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)debugTime));
        JobMessage unknownJobMessage = new JobMessage();
        unknownJobMessage.setMessageImportance("JOB_MESSAGE_UNKNOWN");
        unknownJobMessage.setMessageText("UNKNOWNUNKNOWN");
        unknownJobMessage.setTime("");
        JobMessage emptyJobMessage = new JobMessage();
        emptyJobMessage.setMessageImportance("JOB_MESSAGE_EMPTY");
        emptyJobMessage.setTime(TimeUtil.toCloudTime((ReadableInstant)unknownTime));
        new MonitoringUtil.LoggingHandler().process(Arrays.asList(errorJobMessage, warningJobMessage, basicJobMessage, detailedJobMessage, debugJobMessage, unknownJobMessage));
        this.expectedLogs.verifyError("ERRORERROR");
        this.expectedLogs.verifyError(errorTime.toString());
        this.expectedLogs.verifyWarn("WARNINGWARNING");
        this.expectedLogs.verifyWarn(warningTime.toString());
        this.expectedLogs.verifyInfo("BASICBASIC");
        this.expectedLogs.verifyInfo(basicTime.toString());
        this.expectedLogs.verifyInfo("DETAILEDDETAILED");
        this.expectedLogs.verifyInfo(detailedTime.toString());
        this.expectedLogs.verifyDebug("DEBUGDEBUG");
        this.expectedLogs.verifyDebug(debugTime.toString());
        this.expectedLogs.verifyTrace("UNKNOWN TIMESTAMP");
        this.expectedLogs.verifyTrace("UNKNOWNUNKNOWN");
        this.expectedLogs.verifyNotLogged(unknownTime.toString());
    }
}

