/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.repackaged.com.google.common.base.Strings;
import org.apache.beam.sdk.testing.ResetDateTimeProvider;
import org.apache.beam.sdk.testing.RestoreSystemProperties;
import org.apache.beam.sdk.util.IOChannelUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowPipelineOptionsTest {
    @Rule
    public TestRule restoreSystemProperties = new RestoreSystemProperties();
    @Rule
    public ResetDateTimeProvider resetDateTimeProviderRule = new ResetDateTimeProvider();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testJobNameIsSet() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setJobName("TestJobName");
        Assert.assertEquals((Object)"TestJobName", (Object)options.getJobName());
    }

    @Test
    public void testUserNameIsNotSet() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().remove("user.name");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("TestApplication");
        Assert.assertEquals((Object)"testapplication--1208190706", (Object)options.getJobName());
        Assert.assertTrue((options.getJobName().length() <= 40 ? 1 : 0) != 0);
    }

    @Test
    public void testAppNameAndUserNameAreLong() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "abcdeabcdeabcdeabcdeabcdeabcde");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("1234567890123456789012345678901234567890");
        Assert.assertEquals((Object)"a234567890123456789012345678901234567890-abcdeabcdeabcdeabcdeabcdeabcde-1208190706", (Object)options.getJobName());
    }

    @Test
    public void testAppNameIsLong() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "abcde");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("1234567890123456789012345678901234567890");
        Assert.assertEquals((Object)"a234567890123456789012345678901234567890-abcde-1208190706", (Object)options.getJobName());
    }

    @Test
    public void testUserNameIsLong() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "abcdeabcdeabcdeabcdeabcdeabcde");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("1234567890");
        Assert.assertEquals((Object)"a234567890-abcdeabcdeabcdeabcdeabcdeabcde-1208190706", (Object)options.getJobName());
    }

    @Test
    public void testUtf8UserNameAndApplicationNameIsNormalized() {
        this.resetDateTimeProviderRule.setDateTimeFixed("2014-12-08T19:07:06.698Z");
        System.getProperties().put("user.name", "\u00f0i \u0131nt\u0259\u02c8n\u00e6\u0283\u0259n\u0259l ");
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setAppName("f\u0259\u02c8n\u025bt\u0131k \u0259so\u028asi\u02c8e\u0131\u0283n");
        Assert.assertEquals((Object)"f00n0t0k00so0si0e00n-0i00nt00n000n0l0-1208190706", (Object)options.getJobName());
    }

    @Test
    public void testStagingLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        IOChannelUtils.registerStandardIOFactories((PipelineOptions)options);
        options.setTempLocation("file://temp_location");
        options.setStagingLocation("gs://staging_location");
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)options.getGcpTempLocation()));
        Assert.assertEquals((Object)"gs://staging_location", (Object)options.getStagingLocation());
    }

    @Test
    public void testDefaultToTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        IOChannelUtils.registerStandardIOFactories((PipelineOptions)options);
        options.setTempLocation("gs://temp_location");
        Assert.assertEquals((Object)"gs://temp_location", (Object)options.getGcpTempLocation());
        Assert.assertEquals((Object)"gs://temp_location/staging", (Object)options.getStagingLocation());
    }

    @Test
    public void testDefaultToGcpTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        IOChannelUtils.registerStandardIOFactories((PipelineOptions)options);
        options.setTempLocation("gs://temp_location");
        options.setGcpTempLocation("gs://gcp_temp_location");
        Assert.assertEquals((Object)"gs://gcp_temp_location/staging", (Object)options.getStagingLocation());
    }

    @Test
    public void testDefaultNoneGcsTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setTempLocation("file://temp_location");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Error constructing default value for stagingLocation: gcpTempLocation is missing.");
        options.getStagingLocation();
    }

    @Test
    public void testDefaultInvalidGcpTempLocation() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setGcpTempLocation("file://temp_location");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Error constructing default value for stagingLocation: gcpTempLocation is not a valid GCS path");
        options.getStagingLocation();
    }

    @Test
    public void testDefaultStagingLocationUnset() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Error constructing default value for stagingLocation: gcpTempLocation is missing.");
        options.getStagingLocation();
    }
}

