/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.JobMessage;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.runners.dataflow.util.TimeUtil;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.TestCredential;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MonitoringUtilTest {
    private static final String PROJECT_ID = "someProject";
    private static final String JOB_ID = "1234";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testGetJobMessages() throws IOException {
        Dataflow.Projects.Jobs.Messages mockMessages = (Dataflow.Projects.Jobs.Messages)Mockito.mock(Dataflow.Projects.Jobs.Messages.class);
        Dataflow.Projects.Jobs.Messages.List firstRequest = (Dataflow.Projects.Jobs.Messages.List)Mockito.mock(Dataflow.Projects.Jobs.Messages.List.class);
        Dataflow.Projects.Jobs.Messages.List secondRequest = (Dataflow.Projects.Jobs.Messages.List)Mockito.mock(Dataflow.Projects.Jobs.Messages.List.class);
        Mockito.when((Object)mockMessages.list(PROJECT_ID, JOB_ID)).thenReturn((Object)firstRequest).thenReturn((Object)secondRequest);
        ListJobMessagesResponse firstResponse = new ListJobMessagesResponse();
        firstResponse.setJobMessages(new ArrayList());
        for (int i = 0; i < 100; ++i) {
            JobMessage message = new JobMessage();
            int n = i;
            message.setId(new StringBuilder(19).append("message_").append(n).toString());
            message.setTime(TimeUtil.toCloudTime((ReadableInstant)new Instant((long)i)));
            firstResponse.getJobMessages().add(message);
        }
        String pageToken = "page_token";
        firstResponse.setNextPageToken(pageToken);
        ListJobMessagesResponse secondResponse = new ListJobMessagesResponse();
        secondResponse.setJobMessages(new ArrayList());
        for (int i = 100; i < 150; ++i) {
            JobMessage message = new JobMessage();
            int n = i;
            message.setId(new StringBuilder(19).append("message_").append(n).toString());
            message.setTime(TimeUtil.toCloudTime((ReadableInstant)new Instant((long)i)));
            secondResponse.getJobMessages().add(message);
        }
        Mockito.when((Object)firstRequest.execute()).thenReturn((Object)firstResponse);
        Mockito.when((Object)secondRequest.execute()).thenReturn((Object)secondResponse);
        MonitoringUtil util = new MonitoringUtil(PROJECT_ID, mockMessages);
        ArrayList messages = util.getJobMessages(JOB_ID, -1L);
        ((Dataflow.Projects.Jobs.Messages.List)Mockito.verify((Object)secondRequest)).setPageToken(pageToken);
        Assert.assertEquals((long)150L, (long)messages.size());
    }

    @Test
    public void testToStateCreatesState() {
        String stateName = "JOB_STATE_DONE";
        PipelineResult.State result = MonitoringUtil.toState((String)stateName);
        Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)result);
    }

    @Test
    public void testToStateWithNullReturnsUnknown() {
        String stateName = null;
        PipelineResult.State result = MonitoringUtil.toState(stateName);
        Assert.assertEquals((Object)PipelineResult.State.UNKNOWN, (Object)result);
    }

    @Test
    public void testToStateWithOtherValueReturnsUnknown() {
        String stateName = "FOO_BAR_BAZ";
        PipelineResult.State result = MonitoringUtil.toState((String)stateName);
        Assert.assertEquals((Object)PipelineResult.State.UNKNOWN, (Object)result);
    }

    @Test
    public void testDontOverrideEndpointWithDefaultApi() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setProject(PROJECT_ID);
        options.setGcpCredential((Credential)new TestCredential());
        String cancelCommand = MonitoringUtil.getGcloudCancelCommand((DataflowPipelineOptions)options, (String)JOB_ID);
        Assert.assertEquals((Object)"gcloud alpha dataflow jobs --project=someProject cancel 1234", (Object)cancelCommand);
    }

    @Test
    public void testOverridesEndpointWithStagedDataflowEndpoint() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.create().as(DataflowPipelineOptions.class);
        options.setProject(PROJECT_ID);
        options.setGcpCredential((Credential)new TestCredential());
        String stagingDataflowEndpoint = "v0neverExisted";
        options.setDataflowEndpoint(stagingDataflowEndpoint);
        String cancelCommand = MonitoringUtil.getGcloudCancelCommand((DataflowPipelineOptions)options, (String)JOB_ID);
        Assert.assertEquals((Object)"CLOUDSDK_API_ENDPOINT_OVERRIDES_DATAFLOW=https://dataflow.googleapis.com/v0neverExisted/ gcloud alpha dataflow jobs --project=someProject cancel 1234", (Object)cancelCommand);
    }
}

