/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.auth.oauth2.Credential;
import org.apache.beam.runners.dataflow.DataflowPipelineRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.DataflowPathValidator;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.TestCredential;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DataflowPathValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private GcsUtil mockGcsUtil;
    private DataflowPathValidator validator;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockGcsUtil.bucketExists((GcsPath)Matchers.any(GcsPath.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockGcsUtil.isGcsPatternSupported(Matchers.anyString())).thenCallRealMethod();
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setGcpCredential((Credential)new TestCredential());
        options.setRunner(DataflowPipelineRunner.class);
        options.setGcsUtil(this.mockGcsUtil);
        this.validator = new DataflowPathValidator(options);
    }

    @Test
    public void testValidFilePattern() {
        this.validator.validateInputFilePatternSupported("gs://bucket/path");
    }

    @Test
    public void testInvalidFilePattern() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("DataflowPipelineRunner expected a valid 'gs://' path but was given '/local/path'");
        this.validator.validateInputFilePatternSupported("/local/path");
    }

    @Test
    public void testWhenBucketDoesNotExist() throws Exception {
        Mockito.when((Object)this.mockGcsUtil.bucketExists((GcsPath)Matchers.any(GcsPath.class))).thenReturn((Object)false);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Could not find file gs://non-existent-bucket/location");
        this.validator.validateInputFilePatternSupported("gs://non-existent-bucket/location");
    }

    @Test
    public void testValidOutputPrefix() {
        this.validator.validateOutputFilePrefixSupported("gs://bucket/path");
    }

    @Test
    public void testInvalidOutputPrefix() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("DataflowPipelineRunner expected a valid 'gs://' path but was given '/local/path'");
        this.validator.validateOutputFilePrefixSupported("/local/path");
    }
}

