/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.transforms;

import org.apache.beam.runners.dataflow.DataflowPipelineRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.InvalidWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.NoopPathValidator;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowViewTest {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    private Pipeline createTestBatchRunner() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowPipelineRunner.class);
        options.setProject("someproject");
        options.setStagingLocation("gs://staging");
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setDataflowClient(null);
        return Pipeline.create((PipelineOptions)options);
    }

    private Pipeline createTestStreamingRunner() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowPipelineRunner.class);
        options.setStreaming(true);
        options.setProject("someproject");
        options.setStagingLocation("gs://staging");
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setDataflowClient(null);
        return Pipeline.create((PipelineOptions)options);
    }

    private void testViewUnbounded(Pipeline pipeline, PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>> view) {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to create a side-input view from input");
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"non-bounded PCollection")));
        ((PCollection)pipeline.apply((PTransform)new PTransform<PBegin, PCollection<KV<String, Integer>>>(){

            public PCollection<KV<String, Integer>> apply(PBegin input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED).setTypeDescriptorInternal((TypeDescriptor)new TypeDescriptor<KV<String, Integer>>(){});
            }
        })).apply(view);
    }

    private void testViewNonmerging(Pipeline pipeline, PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>> view) {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to create a side-input view from input");
        this.thrown.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"Consumed by GroupByKey")));
        ((PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new KV[]{KV.of((Object)"hello", (Object)5)}))).apply((PTransform)Window.into((WindowFn)new InvalidWindows("Consumed by GroupByKey", (WindowFn)FixedWindows.of((Duration)Duration.standardHours((long)1L)))))).apply(view);
    }

    @Test
    public void testViewUnboundedAsSingletonBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewUnboundedAsSingletonStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewUnboundedAsIterableBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewUnboundedAsIterableStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewUnboundedAsListBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewUnboundedAsListStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewUnboundedAsMapBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewUnboundedAsMapStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewUnboundedAsMultimapBatch() {
        this.testViewUnbounded(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }

    @Test
    public void testViewUnboundedAsMultimapStreaming() {
        this.testViewUnbounded(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }

    @Test
    public void testViewNonmergingAsSingletonBatch() {
        this.testViewNonmerging(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewNonmergingAsSingletonStreaming() {
        this.testViewNonmerging(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asSingleton());
    }

    @Test
    public void testViewNonmergingAsIterableBatch() {
        this.testViewNonmerging(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewNonmergingAsIterableStreaming() {
        this.testViewNonmerging(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asIterable());
    }

    @Test
    public void testViewNonmergingAsListBatch() {
        this.testViewNonmerging(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewNonmergingAsListStreaming() {
        this.testViewNonmerging(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asList());
    }

    @Test
    public void testViewNonmergingAsMapBatch() {
        this.testViewNonmerging(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewNonmergingAsMapStreaming() {
        this.testViewNonmerging(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMap());
    }

    @Test
    public void testViewNonmergingAsMultimapBatch() {
        this.testViewNonmerging(this.createTestBatchRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }

    @Test
    public void testViewNonmergingAsMultimapStreaming() {
        this.testViewNonmerging(this.createTestStreamingRunner(), (PTransform<PCollection<KV<String, Integer>>, ? extends PCollectionView<?>>)View.asMultimap());
    }
}

