/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.transforms;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.dataflow.DataflowPipelineRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.NoopPathValidator;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowGroupByKeyTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private Pipeline createTestServiceRunner() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowPipelineRunner.class);
        options.setProject("someproject");
        options.setStagingLocation("gs://staging");
        options.setPathValidatorClass(NoopPathValidator.class);
        options.setDataflowClient(null);
        return Pipeline.create((PipelineOptions)options);
    }

    @Test
    public void testInvalidWindowsService() {
        Pipeline p = this.createTestServiceRunner();
        List<KV> ungroupedPairs = Arrays.asList(new KV[0]);
        PCollection input = (PCollection)((PCollection)p.apply((PTransform)Create.of(ungroupedPairs).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)BigEndianIntegerCoder.of())))).apply((PTransform)Window.into((WindowFn)Sessions.withGapDuration((Duration)Duration.standardMinutes((long)1L))));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("GroupByKey must have a valid Window merge function");
        ((PCollection)input.apply("GroupByKey", (PTransform)GroupByKey.create())).apply("GroupByKeyAgain", (PTransform)GroupByKey.create());
    }

    @Test
    public void testGroupByKeyServiceUnbounded() {
        Pipeline p = this.createTestServiceRunner();
        PCollection input = (PCollection)p.apply((PTransform)new PTransform<PBegin, PCollection<KV<String, Integer>>>(){

            public PCollection<KV<String, Integer>> apply(PBegin input) {
                return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED).setTypeDescriptorInternal((TypeDescriptor)new TypeDescriptor<KV<String, Integer>>(){});
            }
        });
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("GroupByKey cannot be applied to non-bounded PCollection in the GlobalWindow without a trigger. Use a Window.into or Window.triggering transform prior to GroupByKey.");
        input.apply("GroupByKey", (PTransform)GroupByKey.create());
    }
}

