/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.beam.runners.dataflow.options.DataflowWorkerLoggingOptions;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowWorkerLoggingOptionsTest {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testWorkerLogLevelOverrideWithInvalidLogLevel() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Unsupported log level");
        DataflowWorkerLoggingOptions.WorkerLogLevelOverrides.from((Map)ImmutableMap.of((Object)"Name", (Object)"FakeLevel"));
    }

    @Test
    public void testWorkerLogLevelOverrideForClass() throws Exception {
        Assert.assertEquals((Object)"{\"org.junit.Test\":\"WARN\"}", (Object)MAPPER.writeValueAsString((Object)new DataflowWorkerLoggingOptions.WorkerLogLevelOverrides().addOverrideForClass(Test.class, DataflowWorkerLoggingOptions.Level.WARN)));
    }

    @Test
    public void testWorkerLogLevelOverrideForPackage() throws Exception {
        Assert.assertEquals((Object)"{\"org.junit\":\"WARN\"}", (Object)MAPPER.writeValueAsString((Object)new DataflowWorkerLoggingOptions.WorkerLogLevelOverrides().addOverrideForPackage(Test.class.getPackage(), DataflowWorkerLoggingOptions.Level.WARN)));
    }

    @Test
    public void testWorkerLogLevelOverrideForName() throws Exception {
        Assert.assertEquals((Object)"{\"A\":\"WARN\"}", (Object)MAPPER.writeValueAsString((Object)new DataflowWorkerLoggingOptions.WorkerLogLevelOverrides().addOverrideForName("A", DataflowWorkerLoggingOptions.Level.WARN)));
    }

    @Test
    public void testSerializationAndDeserializationOf() throws Exception {
        String testValue = "{\"A\":\"WARN\"}";
        Assert.assertEquals((Object)testValue, (Object)MAPPER.writeValueAsString(MAPPER.readValue(testValue, DataflowWorkerLoggingOptions.WorkerLogLevelOverrides.class)));
    }
}

