/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.io;

import com.google.api.client.auth.oauth2.Credential;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import org.apache.beam.runners.dataflow.testing.TestDataflowPipelineOptions;
import org.apache.beam.runners.dataflow.transforms.DataflowDisplayDataEvaluator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.TestCredential;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class DataflowTextIOTest {
    private TestDataflowPipelineOptions buildTestPipelineOptions() {
        TestDataflowPipelineOptions options = (TestDataflowPipelineOptions)PipelineOptionsFactory.as(TestDataflowPipelineOptions.class);
        options.setGcpCredential((Credential)new TestCredential());
        return options;
    }

    private GcsUtil buildMockGcsUtil() throws IOException {
        GcsUtil mockGcsUtil = (GcsUtil)Mockito.mock(GcsUtil.class);
        Mockito.when((Object)mockGcsUtil.open((GcsPath)Mockito.any(GcsPath.class))).then((Answer)new Answer<SeekableByteChannel>(){

            public SeekableByteChannel answer(InvocationOnMock invocation) throws Throwable {
                return FileChannel.open(Files.createTempFile("channel-", ".tmp", new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE);
            }
        });
        Mockito.when((Object)mockGcsUtil.expand((GcsPath)Mockito.any(GcsPath.class))).then((Answer)new Answer<List<GcsPath>>(){

            public List<GcsPath> answer(InvocationOnMock invocation) throws Throwable {
                return ImmutableList.of((Object)((GcsPath)invocation.getArguments()[0]));
            }
        });
        return mockGcsUtil;
    }

    @Test
    public void testGoodWildcards() throws Exception {
        TestDataflowPipelineOptions options = this.buildTestPipelineOptions();
        options.setGcsUtil(this.buildMockGcsUtil());
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        this.applyRead(pipeline, "gs://bucket/foo");
        this.applyRead(pipeline, "gs://bucket/foo/");
        this.applyRead(pipeline, "gs://bucket/foo/*");
        this.applyRead(pipeline, "gs://bucket/foo/?");
        this.applyRead(pipeline, "gs://bucket/foo/[0-9]");
        this.applyRead(pipeline, "gs://bucket/foo/*baz*");
        this.applyRead(pipeline, "gs://bucket/foo/*baz?");
        this.applyRead(pipeline, "gs://bucket/foo/[0-9]baz?");
        this.applyRead(pipeline, "gs://bucket/foo/baz/*");
        this.applyRead(pipeline, "gs://bucket/foo/baz/*wonka*");
        this.applyRead(pipeline, "gs://bucket/foo/*baz/wonka*");
        this.applyRead(pipeline, "gs://bucket/foo*/baz");
        this.applyRead(pipeline, "gs://bucket/foo?/baz");
        this.applyRead(pipeline, "gs://bucket/foo[0-9]/baz");
        pipeline.run();
    }

    private void applyRead(Pipeline pipeline, String path) {
        pipeline.apply(new StringBuilder(6 + String.valueOf(path).length()).append("Read(").append(path).append(")").toString(), (PTransform)TextIO.Read.from((String)path));
    }

    @Test
    public void testPrimitiveWriteDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        TextIO.Write.Bound write = TextIO.Write.to((String)"foobar");
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        Assert.assertThat((String)"TextIO.Write should include the file prefix in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)DisplayDataMatchers.hasValue((Matcher)Matchers.startsWith((String)"foobar")))));
    }

    @Test
    public void testPrimitiveReadDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        TextIO.Read.Bound read = TextIO.Read.from((String)"foobar").withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)read);
        Assert.assertThat((String)"TextIO.Read should include the file prefix in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)DisplayDataMatchers.hasValue((Matcher)Matchers.startsWith((String)"foobar")))));
    }
}

