/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.io;

import java.util.Set;
import org.apache.beam.runners.dataflow.transforms.DataflowDisplayDataEvaluator;
import org.apache.beam.sdk.io.PubsubIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowPubsubIOTest {
    @Test
    public void testPrimitiveWriteDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        PubsubIO.Write.Bound write = PubsubIO.Write.topic((String)"projects/project/topics/topic");
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        Assert.assertThat((String)"PubsubIO.Write should include the topic in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"topic")));
    }

    @Test
    public void testPrimitiveReadDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        PubsubIO.Read.Bound read = PubsubIO.Read.subscription((String)"projects/project/subscriptions/subscription").maxNumRecords(1);
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)read);
        Assert.assertThat((String)"PubsubIO.Read should include the subscription in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"subscription")));
    }
}

