/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.io;

import com.google.api.services.datastore.DatastoreV1;
import java.util.Set;
import org.apache.beam.runners.dataflow.transforms.DataflowDisplayDataEvaluator;
import org.apache.beam.sdk.io.DatastoreIO;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.Write;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DataflowDatastoreIOTest {
    @Test
    public void testSourcePrimitiveDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        Read.Bounded read = DatastoreIO.readFrom((String)"myDataset", (DatastoreV1.Query)DatastoreV1.Query.newBuilder().build());
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)read);
        Assert.assertThat((String)"DatastoreIO read should include the dataset in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"dataset")));
    }

    @Test
    public void testSinkPrimitiveDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        Write.Bound write = DatastoreIO.writeTo((String)"myDataset");
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        Assert.assertThat((String)"DatastoreIO write should include the dataset in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"dataset")));
    }
}

