/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.io;

import com.google.api.services.bigquery.model.TableSchema;
import java.util.Set;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.transforms.DataflowDisplayDataEvaluator;
import org.apache.beam.sdk.io.BigQueryIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DataflowBigQueryIOTest {
    @Test
    public void testTableSourcePrimitiveDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        BigQueryIO.Read.Bound read = BigQueryIO.Read.from((String)"project:dataset.tableId").withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)read);
        Assert.assertThat((String)"BigQueryIO.Read should include the table spec in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"table")));
    }

    @Test
    public void testQuerySourcePrimitiveDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        BigQueryIO.Read.Bound read = BigQueryIO.Read.fromQuery((String)"foobar").withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)read);
        Assert.assertThat((String)"BigQueryIO.Read should include the query in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"query")));
    }

    @Test
    public void testBatchSinkPrimitiveDisplayData() {
        DataflowPipelineOptions options = DataflowDisplayDataEvaluator.getDefaultOptions();
        options.setStreaming(false);
        this.testSinkPrimitiveDisplayData(options);
    }

    @Test
    public void testStreamingSinkPrimitiveDisplayData() {
        DataflowPipelineOptions options = DataflowDisplayDataEvaluator.getDefaultOptions();
        options.setStreaming(true);
        this.testSinkPrimitiveDisplayData(options);
    }

    private void testSinkPrimitiveDisplayData(DataflowPipelineOptions options) {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create(options);
        BigQueryIO.Write.Bound write = BigQueryIO.Write.to((String)"project:dataset.table").withSchema(new TableSchema().set("col1", (Object)"type1").set("col2", (Object)"type2")).withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        Assert.assertThat((String)"BigQueryIO.Write should include the table spec in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"tableSpec")));
        Assert.assertThat((String)"BigQueryIO.Write should include the table schema in its primitive display data", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"schema")));
    }
}

