/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.io;

import java.util.Set;
import org.apache.avro.Schema;
import org.apache.beam.runners.dataflow.transforms.DataflowDisplayDataEvaluator;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowAvroIOTest {
    @Test
    public void testPrimitiveWriteDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        AvroIO.Write.Bound write = AvroIO.Write.to((String)"foo").withSchema(Schema.create((Schema.Type)Schema.Type.STRING)).withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        Assert.assertThat((String)"AvroIO.Write should include the file pattern in its primitive transform", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"fileNamePattern")));
    }

    @Test
    public void testPrimitiveReadDisplayData() {
        DisplayDataEvaluator evaluator = DataflowDisplayDataEvaluator.create();
        AvroIO.Read.Bound read = AvroIO.Read.from((String)"foo.*").withSchema(Schema.create((Schema.Type)Schema.Type.STRING)).withoutValidation();
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)read);
        Assert.assertThat((String)"AvroIO.Read should include the file pattern in its primitive transform", (Object)displayData, (Matcher)Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"filePattern")));
    }
}

