/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.Step;
import com.google.api.services.dataflow.model.WorkerPool;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.DataflowPipelineRunner;
import org.apache.beam.runners.dataflow.DataflowPipelineTranslator;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.runners.dataflow.util.OutputReference;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdk.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.runners.RecordingPipelineVisitor;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.GcsUtil;
import org.apache.beam.sdk.util.Structs;
import org.apache.beam.sdk.util.TestCredential;
import org.apache.beam.sdk.util.WindowingStrategy;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class DataflowPipelineTranslatorTest
implements Serializable {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    private Pipeline buildPipeline(DataflowPipelineOptions options) {
        options.setRunner(DataflowPipelineRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)p.apply((PTransform)TextIO.Read.named((String)"ReadMyFile").from("gs://bucket/object"))).apply((PTransform)TextIO.Write.named((String)"WriteMyFile").to("gs://bucket/object"));
        return p;
    }

    private static Dataflow buildMockDataflow(ArgumentMatcher<Job> jobMatcher) throws IOException {
        Dataflow mockDataflowClient = (Dataflow)Mockito.mock(Dataflow.class);
        Dataflow.Projects mockProjects = (Dataflow.Projects)Mockito.mock(Dataflow.Projects.class);
        Dataflow.Projects.Jobs mockJobs = (Dataflow.Projects.Jobs)Mockito.mock(Dataflow.Projects.Jobs.class);
        Dataflow.Projects.Jobs.Create mockRequest = (Dataflow.Projects.Jobs.Create)Mockito.mock(Dataflow.Projects.Jobs.Create.class);
        Mockito.when((Object)mockDataflowClient.projects()).thenReturn((Object)mockProjects);
        Mockito.when((Object)mockProjects.jobs()).thenReturn((Object)mockJobs);
        Mockito.when((Object)mockJobs.create((String)Matchers.eq((Object)"someProject"), (Job)Matchers.argThat(jobMatcher))).thenReturn((Object)mockRequest);
        Job resultJob = new Job();
        resultJob.setId("newid");
        Mockito.when((Object)mockRequest.execute()).thenReturn((Object)resultJob);
        return mockDataflowClient;
    }

    private static DataflowPipelineOptions buildPipelineOptions() throws IOException {
        GcsUtil mockGcsUtil = (GcsUtil)Mockito.mock(GcsUtil.class);
        Mockito.when((Object)mockGcsUtil.expand((GcsPath)Matchers.any(GcsPath.class))).then((Answer)new Answer<List<GcsPath>>(){

            public List<GcsPath> answer(InvocationOnMock invocation) throws Throwable {
                return ImmutableList.of((Object)((GcsPath)invocation.getArguments()[0]));
            }
        });
        Mockito.when((Object)mockGcsUtil.bucketExists((GcsPath)Matchers.any(GcsPath.class))).thenReturn((Object)true);
        Mockito.when((Object)mockGcsUtil.isGcsPatternSupported(Matchers.anyString())).thenCallRealMethod();
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setRunner(DataflowPipelineRunner.class);
        options.setGcpCredential((Credential)new TestCredential());
        options.setJobName("some-job-name");
        options.setProject("some-project");
        options.setTempLocation(GcsPath.fromComponents((String)"somebucket", (String)"some/path").toString());
        options.setFilesToStage(new LinkedList());
        options.setDataflowClient(DataflowPipelineTranslatorTest.buildMockDataflow(new IsValidCreateRequest()));
        options.setGcsUtil(mockGcsUtil);
        return options;
    }

    @Test
    public void testSettingOfSdkPipelineOptions() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setRunner(DataflowPipelineRunner.class);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("appName", "DataflowPipelineTranslatorTest");
        settings.put("project", "some-project");
        settings.put("pathValidatorClass", "org.apache.beam.runners.dataflow.util.DataflowPathValidator");
        settings.put("runner", "org.apache.beam.runners.dataflow.DataflowPipelineRunner");
        settings.put("jobName", "some-job-name");
        settings.put("tempLocation", "gs://somebucket/some/path");
        settings.put("stagingLocation", "gs://somebucket/some/path/staging");
        settings.put("stableUniqueNames", "WARNING");
        settings.put("streaming", false);
        settings.put("numberOfWorkerHarnessThreads", 0);
        settings.put("experiments", null);
        Map sdkPipelineOptions = job.getEnvironment().getSdkPipelineOptions();
        Assert.assertThat((Object)sdkPipelineOptions, (Matcher)org.hamcrest.Matchers.hasKey((Object)"options"));
        Assert.assertEquals(settings, sdkPipelineOptions.get("options"));
    }

    @Test
    public void testNetworkConfig() throws IOException {
        String testNetwork = "test-network";
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setNetwork("test-network");
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)"test-network", (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getNetwork());
    }

    @Test
    public void testNetworkConfigMissing() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getNetwork());
    }

    @Test
    public void testSubnetworkConfig() throws IOException {
        String testSubnetwork = "regions/REGION/subnetworks/SUBNETWORK";
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setSubnetwork("regions/REGION/subnetworks/SUBNETWORK");
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)"regions/REGION/subnetworks/SUBNETWORK", (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getSubnetwork());
    }

    @Test
    public void testSubnetworkConfigMissing() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getSubnetwork());
    }

    @Test
    public void testScalingAlgorithmMissing() throws IOException {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getAlgorithm());
        Assert.assertEquals((long)0L, (long)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getMaxNumWorkers().intValue());
    }

    @Test
    public void testScalingAlgorithmNone() throws IOException {
        DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType noScaling = DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType.NONE;
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setAutoscalingAlgorithm(noScaling);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)"AUTOSCALING_ALGORITHM_NONE", (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getAlgorithm());
        Assert.assertEquals((long)0L, (long)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getMaxNumWorkers().intValue());
    }

    @Test
    public void testMaxNumWorkersIsPassedWhenNoAlgorithmIsSet() throws IOException {
        DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType noScaling = null;
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setMaxNumWorkers(42);
        options.setAutoscalingAlgorithm(noScaling);
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertNull((Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getAlgorithm());
        Assert.assertEquals((long)42L, (long)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getAutoscalingSettings().getMaxNumWorkers().intValue());
    }

    @Test
    public void testZoneConfig() throws IOException {
        String testZone = "test-zone-1";
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setZone("test-zone-1");
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)"test-zone-1", (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getZone());
    }

    @Test
    public void testWorkerMachineTypeConfig() throws IOException {
        String testMachineType = "test-machine-type";
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setWorkerMachineType("test-machine-type");
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        WorkerPool workerPool = (WorkerPool)job.getEnvironment().getWorkerPools().get(0);
        Assert.assertEquals((Object)"test-machine-type", (Object)workerPool.getMachineType());
    }

    @Test
    public void testDiskSizeGbConfig() throws IOException {
        Integer diskSizeGb = 1234;
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setDiskSizeGb(diskSizeGb.intValue());
        Pipeline p = this.buildPipeline(options);
        p.traverseTopologically((Pipeline.PipelineVisitor)new RecordingPipelineVisitor());
        Job job = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options).translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)1L, (long)job.getEnvironment().getWorkerPools().size());
        Assert.assertEquals((Object)diskSizeGb, (Object)((WorkerPool)job.getEnvironment().getWorkerPools().get(0)).getDiskSizeGb());
    }

    @Test
    public void testPredefinedAddStep() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        DataflowPipelineTranslator.registerTransformTranslator(EmbeddedTransform.class, (DataflowPipelineTranslator.TransformTranslator)new EmbeddedTranslator());
        Step predefinedStep = DataflowPipelineTranslatorTest.createPredefinedStep();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)pipeline.apply((PTransform)TextIO.Read.named((String)"ReadMyFile").from("gs://bucket/in"))).apply((PTransform)ParDo.of((DoFn)new NoOpFn()))).apply((PTransform)new EmbeddedTransform(predefinedStep.clone()))).apply((PTransform)ParDo.of((DoFn)new NoOpFn()));
        Job job = translator.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)4L, (long)steps.size());
        OutputReference step1Out = DataflowPipelineTranslatorTest.getOutputPortReference((Step)steps.get(1));
        Map step2In = Structs.getDictionary((Map)((Step)steps.get(2)).getProperties(), (String)"parallel_input");
        Assert.assertEquals((Object)step1Out, (Object)step2In);
        OutputReference step2Out = DataflowPipelineTranslatorTest.getOutputPortReference((Step)steps.get(2));
        Map step3In = Structs.getDictionary((Map)((Step)steps.get(3)).getProperties(), (String)"parallel_input");
        Assert.assertEquals((Object)step2Out, (Object)step3In);
        Step predefinedStepClone = predefinedStep.clone();
        Step embeddedStepClone = ((Step)steps.get(2)).clone();
        predefinedStepClone.getProperties().remove("parallel_input");
        embeddedStepClone.getProperties().remove("parallel_input");
        Assert.assertEquals((Object)predefinedStepClone, (Object)embeddedStepClone);
    }

    private static OutputReference getOutputPortReference(Step step) throws Exception {
        List output = (List)step.getProperties().get("output_info");
        String outputTagId = Structs.getString((Map)((Map)Iterables.getOnlyElement((Iterable)output)), (String)"output_name");
        return new OutputReference(step.getName(), outputTagId);
    }

    private static Step createPredefinedStep() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        String stepName = "DoFn1";
        ((PCollection)((PCollection)pipeline.apply((PTransform)TextIO.Read.named((String)"ReadMyFile").from("gs://bucket/in"))).apply((PTransform)ParDo.of((DoFn)new NoOpFn()).named(stepName))).apply((PTransform)TextIO.Write.named((String)"WriteMyFile").to("gs://bucket/out"));
        Job job = translator.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList()).getJob();
        Assert.assertEquals((long)13L, (long)job.getSteps().size());
        Step step = (Step)job.getSteps().get(1);
        Assert.assertEquals((Object)stepName, (Object)Structs.getString((Map)step.getProperties(), (String)"user_name"));
        return step;
    }

    @Test
    public void testMultiGraphPipelineSerialization() throws IOException {
        Pipeline p = Pipeline.create((PipelineOptions)DataflowPipelineTranslatorTest.buildPipelineOptions());
        PCollection input = (PCollection)p.begin().apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}));
        input.apply((PTransform)new UnrelatedOutputCreator());
        input.apply((PTransform)new UnboundOutputCreator());
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)((DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class)));
        t.translate(p, (DataflowPipelineRunner)p.getRunner(), Collections.emptyList());
    }

    @Test
    public void testPartiallyBoundFailure() throws IOException {
        Pipeline p = Pipeline.create((PipelineOptions)DataflowPipelineTranslatorTest.buildPipelineOptions());
        PCollection input = (PCollection)p.begin().apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}));
        this.thrown.expect(IllegalStateException.class);
        input.apply((PTransform)new PartiallyBoundOutputCreator());
        Assert.fail((String)"Failure expected from use of partially bound output");
    }

    @Test
    public void testGoodWildcards() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        this.applyRead(pipeline, "gs://bucket/foo");
        this.applyRead(pipeline, "gs://bucket/foo/");
        this.applyRead(pipeline, "gs://bucket/foo/*");
        this.applyRead(pipeline, "gs://bucket/foo/?");
        this.applyRead(pipeline, "gs://bucket/foo/[0-9]");
        this.applyRead(pipeline, "gs://bucket/foo/*baz*");
        this.applyRead(pipeline, "gs://bucket/foo/*baz?");
        this.applyRead(pipeline, "gs://bucket/foo/[0-9]baz?");
        this.applyRead(pipeline, "gs://bucket/foo/baz/*");
        this.applyRead(pipeline, "gs://bucket/foo/baz/*wonka*");
        this.applyRead(pipeline, "gs://bucket/foo/*baz/wonka*");
        this.applyRead(pipeline, "gs://bucket/foo*/baz");
        this.applyRead(pipeline, "gs://bucket/foo?/baz");
        this.applyRead(pipeline, "gs://bucket/foo[0-9]/baz");
        t.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList());
    }

    private void applyRead(Pipeline pipeline, String path) {
        pipeline.apply(new StringBuilder(6 + String.valueOf(path).length()).append("Read(").append(path).append(")").toString(), (PTransform)TextIO.Read.from((String)path));
    }

    @Test
    public void testBadWildcardRecursive() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DataflowPipelineTranslator t = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        pipeline.apply((PTransform)TextIO.Read.from((String)"gs://bucket/foo**/baz"));
        this.thrown.expectCause(org.hamcrest.Matchers.allOf((Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)org.hamcrest.Matchers.containsString((String)"Unsupported wildcard usage"))));
        t.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList());
    }

    @Test
    public void testToSingletonTranslation() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setExperiments((List)ImmutableList.of((Object)"disable_ism_side_input"));
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1}))).apply((PTransform)View.asSingleton());
        Job job = translator.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)2L, (long)steps.size());
        Step createStep = (Step)steps.get(0);
        Assert.assertEquals((Object)"ParallelRead", (Object)createStep.getKind());
        Step collectionToSingletonStep = (Step)steps.get(1);
        Assert.assertEquals((Object)"CollectionToSingleton", (Object)collectionToSingletonStep.getKind());
    }

    @Test
    public void testToIterableTranslation() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        options.setExperiments((List)ImmutableList.of((Object)"disable_ism_side_input"));
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}))).apply((PTransform)View.asIterable());
        Job job = translator.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)2L, (long)steps.size());
        Step createStep = (Step)steps.get(0);
        Assert.assertEquals((Object)"ParallelRead", (Object)createStep.getKind());
        Step collectionToSingletonStep = (Step)steps.get(1);
        Assert.assertEquals((Object)"CollectionToSingleton", (Object)collectionToSingletonStep.getKind());
    }

    @Test
    public void testToSingletonTranslationWithIsmSideInput() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1}))).apply((PTransform)View.asSingleton());
        Job job = translator.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)5L, (long)steps.size());
        List toIsmRecordOutputs = (List)((Step)steps.get(3)).getProperties().get("output_info");
        Assert.assertTrue((boolean)Structs.getBoolean((Map)((Map)Iterables.getOnlyElement((Iterable)toIsmRecordOutputs)), (String)"use_indexed_format"));
        Step collectionToSingletonStep = (Step)steps.get(4);
        Assert.assertEquals((Object)"CollectionToSingleton", (Object)collectionToSingletonStep.getKind());
    }

    @Test
    public void testToIterableTranslationWithIsmSideInput() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}))).apply((PTransform)View.asIterable());
        Job job = translator.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)3L, (long)steps.size());
        List toIsmRecordOutputs = (List)((Step)steps.get(1)).getProperties().get("output_info");
        Assert.assertTrue((boolean)Structs.getBoolean((Map)((Map)Iterables.getOnlyElement((Iterable)toIsmRecordOutputs)), (String)"use_indexed_format"));
        Step collectionToSingletonStep = (Step)steps.get(2);
        Assert.assertEquals((Object)"CollectionToSingleton", (Object)collectionToSingletonStep.getKind());
    }

    @Test
    public void testStepDisplayData() throws Exception {
        DataflowPipelineOptions options = DataflowPipelineTranslatorTest.buildPipelineOptions();
        DataflowPipelineTranslator translator = DataflowPipelineTranslator.fromOptions((DataflowPipelineOptions)options);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        DoFn<Integer, Integer> fn1 = new DoFn<Integer, Integer>(){

            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output(c.element());
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo", (String)"bar")).add(DisplayData.item((String)"foo2", DataflowPipelineTranslatorTest.class).withLabel("Test Class").withLinkUrl("http://www.google.com"));
            }
        };
        DoFn<Integer, Integer> fn2 = new DoFn<Integer, Integer>(){

            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output(c.element());
            }

            public void populateDisplayData(DisplayData.Builder builder) {
                builder.add(DisplayData.item((String)"foo3", (Integer)1234));
            }
        };
        ParDo.Bound parDo1 = ParDo.of((DoFn)fn1);
        ParDo.Bound parDo2 = ParDo.of((DoFn)fn2);
        ((PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3}))).apply((PTransform)parDo1)).apply((PTransform)parDo2);
        Job job = translator.translate(pipeline, (DataflowPipelineRunner)pipeline.getRunner(), Collections.emptyList()).getJob();
        List steps = job.getSteps();
        Assert.assertEquals((long)3L, (long)steps.size());
        Map parDo1Properties = ((Step)steps.get(1)).getProperties();
        Map parDo2Properties = ((Step)steps.get(2)).getProperties();
        Assert.assertThat((Object)parDo1Properties, (Matcher)org.hamcrest.Matchers.hasKey((Object)"display_data"));
        Collection fn1displayData = (Collection)parDo1Properties.get("display_data");
        Collection fn2displayData = (Collection)parDo2Properties.get("display_data");
        ImmutableSet expectedFn1DisplayData = ImmutableSet.of((Object)ImmutableMap.builder().put((Object)"key", (Object)"foo").put((Object)"type", (Object)"STRING").put((Object)"value", (Object)"bar").put((Object)"namespace", (Object)fn1.getClass().getName()).build(), (Object)ImmutableMap.builder().put((Object)"key", (Object)"fn").put((Object)"label", (Object)"Transform Function").put((Object)"type", (Object)"JAVA_CLASS").put((Object)"value", (Object)fn1.getClass().getName()).put((Object)"shortValue", (Object)fn1.getClass().getSimpleName()).put((Object)"namespace", (Object)parDo1.getClass().getName()).build(), (Object)ImmutableMap.builder().put((Object)"key", (Object)"foo2").put((Object)"type", (Object)"JAVA_CLASS").put((Object)"value", (Object)DataflowPipelineTranslatorTest.class.getName()).put((Object)"shortValue", (Object)DataflowPipelineTranslatorTest.class.getSimpleName()).put((Object)"namespace", (Object)fn1.getClass().getName()).put((Object)"label", (Object)"Test Class").put((Object)"linkUrl", (Object)"http://www.google.com").build());
        ImmutableSet expectedFn2DisplayData = ImmutableSet.of((Object)ImmutableMap.builder().put((Object)"key", (Object)"fn").put((Object)"label", (Object)"Transform Function").put((Object)"type", (Object)"JAVA_CLASS").put((Object)"value", (Object)fn2.getClass().getName()).put((Object)"shortValue", (Object)fn2.getClass().getSimpleName()).put((Object)"namespace", (Object)parDo2.getClass().getName()).build(), (Object)ImmutableMap.builder().put((Object)"key", (Object)"foo3").put((Object)"type", (Object)"INTEGER").put((Object)"value", (Object)1234L).put((Object)"namespace", (Object)fn2.getClass().getName()).build());
        Assert.assertEquals((Object)expectedFn1DisplayData, (Object)ImmutableSet.copyOf((Collection)fn1displayData));
        Assert.assertEquals((Object)expectedFn2DisplayData, (Object)ImmutableSet.copyOf((Collection)fn2displayData));
    }

    private static class PartiallyBoundOutputCreator
    extends PTransform<PCollection<Integer>, PCollectionTuple> {
        public final TupleTag<Integer> sumTag = new TupleTag("sum");
        public final TupleTag<Void> doneTag = new TupleTag("done");

        private PartiallyBoundOutputCreator() {
        }

        public PCollectionTuple apply(PCollection<Integer> input) {
            PCollection sum = (PCollection)input.apply((PTransform)Sum.integersGlobally());
            return PCollectionTuple.of(this.sumTag, (PCollection)sum).and(this.doneTag, PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)input.isBounded()));
        }
    }

    private static class UnboundOutputCreator
    extends PTransform<PCollection<Integer>, PDone> {
        private UnboundOutputCreator() {
        }

        public PDone apply(PCollection<Integer> input) {
            input.apply((PTransform)Count.perElement());
            return PDone.in((Pipeline)input.getPipeline());
        }

        protected Coder<?> getDefaultOutputCoder() {
            return VoidCoder.of();
        }
    }

    private static class UnrelatedOutputCreator
    extends PTransform<PCollection<Integer>, PCollection<Integer>> {
        private UnrelatedOutputCreator() {
        }

        public PCollection<Integer> apply(PCollection<Integer> input) {
            input.apply((PTransform)Count.perElement());
            return (PCollection)input.getPipeline().apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3, 4}));
        }

        protected Coder<?> getDefaultOutputCoder() {
            return VarIntCoder.of();
        }
    }

    private static class EmbeddedTranslator
    implements DataflowPipelineTranslator.TransformTranslator<EmbeddedTransform> {
        private EmbeddedTranslator() {
        }

        public void translate(EmbeddedTransform transform, DataflowPipelineTranslator.TranslationContext context) {
            Structs.addObject((Map)transform.step.getProperties(), (String)"parallel_input", (Map)context.asOutputReference((PValue)context.getInput((PTransform)transform)));
            context.addStep((PTransform)transform, transform.step);
        }
    }

    private static class EmbeddedTransform
    extends PTransform<PCollection<String>, PCollection<String>> {
        private final Step step;

        public EmbeddedTransform(Step step) {
            this.step = step;
        }

        public PCollection<String> apply(PCollection<String> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)input.isBounded());
        }

        protected Coder<?> getDefaultOutputCoder() {
            return StringUtf8Coder.of();
        }
    }

    private static class NoOpFn
    extends DoFn<String, String> {
        private NoOpFn() {
        }

        public void processElement(DoFn.ProcessContext c) throws Exception {
            c.output(c.element());
        }
    }

    private static class IsValidCreateRequest
    extends ArgumentMatcher<Job> {
        private IsValidCreateRequest() {
        }

        public boolean matches(Object o) {
            Job job = (Job)o;
            return job.getId() == null && job.getProjectId() == null && job.getName() != null && job.getType() != null && job.getEnvironment() != null && job.getSteps() != null && job.getCurrentState() == null && job.getCurrentStateTime() == null && job.getExecutionInfo() == null && job.getCreateTime() == null;
        }
    }
}

