/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.ServiceLoader;
import org.apache.beam.runners.dataflow.BlockingDataflowPipelineRunner;
import org.apache.beam.runners.dataflow.DataflowPipelineRegistrar;
import org.apache.beam.runners.dataflow.DataflowPipelineRunner;
import org.apache.beam.runners.dataflow.options.BlockingDataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsRegistrar;
import org.apache.beam.sdk.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.repackaged.com.google.common.collect.Lists;
import org.apache.beam.sdk.runners.PipelineRunnerRegistrar;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataflowPipelineRegistrarTest {
    @Test
    public void testCorrectOptionsAreReturned() {
        Assert.assertEquals((Object)ImmutableList.of(DataflowPipelineOptions.class, BlockingDataflowPipelineOptions.class), (Object)new DataflowPipelineRegistrar.Options().getPipelineOptions());
    }

    @Test
    public void testCorrectRunnersAreReturned() {
        Assert.assertEquals((Object)ImmutableList.of(DataflowPipelineRunner.class, BlockingDataflowPipelineRunner.class), (Object)new DataflowPipelineRegistrar.Runner().getPipelineRunners());
    }

    @Test
    public void testServiceLoaderForOptions() {
        for (PipelineOptionsRegistrar registrar : Lists.newArrayList(ServiceLoader.load(PipelineOptionsRegistrar.class).iterator())) {
            if (!(registrar instanceof DataflowPipelineRegistrar.Options)) continue;
            return;
        }
        String string = String.valueOf(DataflowPipelineRegistrar.Options.class);
        Assert.fail((String)new StringBuilder(17 + String.valueOf(string).length()).append("Expected to find ").append(string).toString());
    }

    @Test
    public void testServiceLoaderForRunner() {
        for (PipelineRunnerRegistrar registrar : Lists.newArrayList(ServiceLoader.load(PipelineRunnerRegistrar.class).iterator())) {
            if (!(registrar instanceof DataflowPipelineRegistrar.Runner)) continue;
            return;
        }
        String string = String.valueOf(DataflowPipelineRegistrar.Runner.class);
        Assert.fail((String)new StringBuilder(17 + String.valueOf(string).length()).append("Expected to find ").append(string).toString());
    }
}

