/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.client.auth.oauth2.Credential;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.dataflow.BlockingDataflowPipelineRunner;
import org.apache.beam.runners.dataflow.DataflowJobCancelledException;
import org.apache.beam.runners.dataflow.DataflowJobException;
import org.apache.beam.runners.dataflow.DataflowJobExecutionException;
import org.apache.beam.runners.dataflow.DataflowJobUpdatedException;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.runners.dataflow.DataflowPipelineRunner;
import org.apache.beam.runners.dataflow.DataflowServiceException;
import org.apache.beam.runners.dataflow.options.BlockingDataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.testing.TestDataflowPipelineOptions;
import org.apache.beam.runners.dataflow.util.MonitoringUtil;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.util.NoopPathValidator;
import org.apache.beam.sdk.util.TestCredential;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BlockingDataflowPipelineRunnerTest {
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(BlockingDataflowPipelineRunner.class);
    @Rule
    public ExpectedException expectedThrown = ExpectedException.none();

    private DataflowPipelineJob createMockJob(String projectId, String jobId, PipelineResult.State terminalState) throws Exception {
        DataflowPipelineJob mockJob = (DataflowPipelineJob)Mockito.mock(DataflowPipelineJob.class);
        Mockito.when((Object)mockJob.getProjectId()).thenReturn((Object)projectId);
        Mockito.when((Object)mockJob.getJobId()).thenReturn((Object)jobId);
        Mockito.when((Object)mockJob.waitToFinish(Matchers.anyLong(), (TimeUnit)((Object)Matchers.isA(TimeUnit.class)), (MonitoringUtil.JobMessagesHandler)Matchers.isA(MonitoringUtil.JobMessagesHandler.class))).thenReturn((Object)terminalState);
        return mockJob;
    }

    private BlockingDataflowPipelineRunner createMockRunner(DataflowPipelineJob job) throws Exception {
        DataflowPipelineRunner mockRunner = (DataflowPipelineRunner)Mockito.mock(DataflowPipelineRunner.class);
        TestDataflowPipelineOptions options = (TestDataflowPipelineOptions)PipelineOptionsFactory.as(TestDataflowPipelineOptions.class);
        options.setProject(job.getProjectId());
        Mockito.when((Object)mockRunner.run((Pipeline)Matchers.isA(Pipeline.class))).thenReturn((Object)job);
        return new BlockingDataflowPipelineRunner(mockRunner, (BlockingDataflowPipelineOptions)options);
    }

    @Test
    public void testJobDoneComplete() throws Exception {
        this.createMockRunner(this.createMockJob("testJobDone-projectId", "testJobDone-jobId", PipelineResult.State.DONE)).run((Pipeline)TestPipeline.create());
        this.expectedLogs.verifyInfo("Job finished with status DONE");
    }

    @Test
    public void testFailedJobThrowsException() throws Exception {
        this.expectedThrown.expect(DataflowJobExecutionException.class);
        this.expectedThrown.expect(DataflowJobExceptionMatcher.expectJob(JobIdMatcher.expectJobId("testFailedJob-jobId")));
        this.createMockRunner(this.createMockJob("testFailedJob-projectId", "testFailedJob-jobId", PipelineResult.State.FAILED)).run((Pipeline)TestPipeline.create());
    }

    @Test
    public void testCancelledJobThrowsException() throws Exception {
        this.expectedThrown.expect(DataflowJobCancelledException.class);
        this.expectedThrown.expect(DataflowJobExceptionMatcher.expectJob(JobIdMatcher.expectJobId("testCancelledJob-jobId")));
        this.createMockRunner(this.createMockJob("testCancelledJob-projectId", "testCancelledJob-jobId", PipelineResult.State.CANCELLED)).run((Pipeline)TestPipeline.create());
    }

    @Test
    public void testUpdatedJobThrowsException() throws Exception {
        this.expectedThrown.expect(DataflowJobUpdatedException.class);
        this.expectedThrown.expect(DataflowJobExceptionMatcher.expectJob(JobIdMatcher.expectJobId("testUpdatedJob-jobId")));
        this.expectedThrown.expect(ReplacedByJobMatcher.expectReplacedBy(JobIdMatcher.expectJobId("testUpdatedJob-replacedByJobId")));
        DataflowPipelineJob job = this.createMockJob("testUpdatedJob-projectId", "testUpdatedJob-jobId", PipelineResult.State.UPDATED);
        DataflowPipelineJob replacedByJob = this.createMockJob("testUpdatedJob-projectId", "testUpdatedJob-replacedByJobId", PipelineResult.State.DONE);
        Mockito.when((Object)job.getReplacedByJob()).thenReturn((Object)replacedByJob);
        this.createMockRunner(job).run((Pipeline)TestPipeline.create());
    }

    @Test
    public void testUnknownJobThrowsException() throws Exception {
        this.expectedThrown.expect(IllegalStateException.class);
        this.createMockRunner(this.createMockJob("testUnknownJob-projectId", "testUnknownJob-jobId", PipelineResult.State.UNKNOWN)).run((Pipeline)TestPipeline.create());
    }

    @Test
    public void testNullJobThrowsException() throws Exception {
        this.expectedThrown.expect(DataflowServiceException.class);
        this.expectedThrown.expect(DataflowJobExceptionMatcher.expectJob(JobIdMatcher.expectJobId("testNullJob-jobId")));
        this.createMockRunner(this.createMockJob("testNullJob-projectId", "testNullJob-jobId", null)).run((Pipeline)TestPipeline.create());
    }

    @Test
    public void testToString() {
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setJobName("TestJobName");
        options.setProject("test-project");
        options.setTempLocation("gs://test/temp/location");
        options.setGcpCredential((Credential)new TestCredential());
        options.setPathValidatorClass(NoopPathValidator.class);
        Assert.assertEquals((Object)"BlockingDataflowPipelineRunner#testjobname", (Object)BlockingDataflowPipelineRunner.fromOptions((PipelineOptions)options).toString());
    }

    private static class ReplacedByJobMatcher<T extends DataflowJobUpdatedException>
    extends TypeSafeMatcher<T> {
        private final Matcher<DataflowPipelineJob> matcher;

        public ReplacedByJobMatcher(Matcher<DataflowPipelineJob> matcher) {
            this.matcher = matcher;
        }

        public boolean matchesSafely(T ex) {
            return this.matcher.matches((Object)ex.getReplacedByJob());
        }

        protected void describeMismatchSafely(T item, Description description) {
            description.appendText("job ");
            this.matcher.describeMismatch((Object)item.getMessage(), description);
        }

        public void describeTo(Description description) {
            description.appendText("exception with replacedByJob() ");
            description.appendDescriptionOf(this.matcher);
        }

        @Factory
        public static <T extends DataflowJobUpdatedException> Matcher<T> expectReplacedBy(Matcher<DataflowPipelineJob> matcher) {
            return new ReplacedByJobMatcher<T>(matcher);
        }
    }

    private static class JobIdMatcher<T extends DataflowPipelineJob>
    extends TypeSafeMatcher<T> {
        private final Matcher<String> matcher;

        public JobIdMatcher(Matcher<String> matcher) {
            this.matcher = matcher;
        }

        public boolean matchesSafely(T job) {
            return this.matcher.matches((Object)job.getJobId());
        }

        protected void describeMismatchSafely(T item, Description description) {
            description.appendText("jobId ");
            this.matcher.describeMismatch((Object)item.getJobId(), description);
        }

        public void describeTo(Description description) {
            description.appendText("job with jobId ");
            description.appendDescriptionOf(this.matcher);
        }

        @Factory
        public static <T extends DataflowPipelineJob> Matcher<T> expectJobId(String jobId) {
            return new JobIdMatcher<T>((Matcher<String>)CoreMatchers.equalTo((Object)jobId));
        }
    }

    private static class DataflowJobExceptionMatcher<T extends DataflowJobException>
    extends TypeSafeMatcher<T> {
        private final Matcher<DataflowPipelineJob> matcher;

        public DataflowJobExceptionMatcher(Matcher<DataflowPipelineJob> matcher) {
            this.matcher = matcher;
        }

        public boolean matchesSafely(T ex) {
            return this.matcher.matches((Object)ex.getJob());
        }

        protected void describeMismatchSafely(T item, Description description) {
            description.appendText("job ");
            this.matcher.describeMismatch((Object)item.getMessage(), description);
        }

        public void describeTo(Description description) {
            description.appendText("exception with job matching ");
            description.appendDescriptionOf(this.matcher);
        }

        @Factory
        public static <T extends DataflowJobException> Matcher<T> expectJob(Matcher<DataflowPipelineJob> matcher) {
            return new DataflowJobExceptionMatcher<T>(matcher);
        }
    }
}

