/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump;

import io.gearpump.cluster.ApplicationStatus;
import io.gearpump.cluster.MasterToAppMaster;
import io.gearpump.cluster.client.ClientContext;
import io.gearpump.cluster.client.RunningApplication;
import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.joda.time.Duration;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class GearpumpPipelineResult
implements PipelineResult {
    private final ClientContext client;
    private final RunningApplication app;
    private boolean finished = false;

    public GearpumpPipelineResult(ClientContext client, RunningApplication app) {
        this.client = client;
        this.app = app;
    }

    public PipelineResult.State getState() {
        if (!this.finished) {
            return this.getGearpumpState();
        }
        return PipelineResult.State.DONE;
    }

    public PipelineResult.State cancel() throws IOException {
        if (!this.finished) {
            this.app.shutDown();
            this.finished = true;
            return PipelineResult.State.CANCELLED;
        }
        return PipelineResult.State.DONE;
    }

    public PipelineResult.State waitUntilFinish(Duration duration) {
        return this.waitUntilFinish();
    }

    public PipelineResult.State waitUntilFinish() {
        if (!this.finished) {
            this.app.waitUntilFinish();
            this.finished = true;
        }
        return PipelineResult.State.DONE;
    }

    public MetricResults metrics() {
        throw new UnsupportedOperationException(String.format("%s does not support querying metrics", this.getClass().getSimpleName()));
    }

    public ClientContext getClientContext() {
        return this.client;
    }

    private PipelineResult.State getGearpumpState() {
        ApplicationStatus status = null;
        List apps = (List)JavaConverters.seqAsJavaListConverter((Seq)this.client.listApps().appMasters()).asJava();
        for (MasterToAppMaster.AppMasterData appData : apps) {
            if (appData.appId() != this.app.appId()) continue;
            status = appData.status();
        }
        if (null == status || status.status().equals("nonexist")) {
            return PipelineResult.State.UNKNOWN;
        }
        if (status.status().equals("active")) {
            return PipelineResult.State.RUNNING;
        }
        if (status.status().equals("succeeded")) {
            return PipelineResult.State.DONE;
        }
        return PipelineResult.State.FAILED;
    }
}

