/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators.utils;

import io.gearpump.streaming.dsl.window.impl.Window;
import java.time.Instant;
import java.util.List;
import org.apache.beam.runners.gearpump.translators.utils.TranslatorUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TranslatorUtilsTest {
    private static final List<KV<org.joda.time.Instant, Instant>> TEST_VALUES = Lists.newArrayList((Object[])new KV[]{KV.of((Object)new org.joda.time.Instant(0L), (Object)Instant.EPOCH), KV.of((Object)new org.joda.time.Instant(42L), (Object)Instant.ofEpochMilli(42L)), KV.of((Object)new org.joda.time.Instant(Long.MIN_VALUE), (Object)Instant.ofEpochMilli(Long.MIN_VALUE)), KV.of((Object)new org.joda.time.Instant(Long.MAX_VALUE), (Object)Instant.ofEpochMilli(Long.MAX_VALUE))});

    @Test
    public void testJodaTimeAndJava8TimeConversion() {
        for (KV<org.joda.time.Instant, Instant> kv : TEST_VALUES) {
            Assert.assertThat((Object)TranslatorUtils.jodaTimeToJava8Time((org.joda.time.Instant)((org.joda.time.Instant)kv.getKey())), (Matcher)Matchers.equalTo((Object)((Instant)kv.getValue())));
            Assert.assertThat((Object)TranslatorUtils.java8TimeToJodaTime((Instant)((Instant)kv.getValue())), (Matcher)Matchers.equalTo((Object)((org.joda.time.Instant)kv.getKey())));
        }
    }

    @Test
    public void testBoundedWindowToGearpumpWindow() {
        Assert.assertThat((Object)TranslatorUtils.boundedWindowToGearpumpWindow((BoundedWindow)new IntervalWindow(new org.joda.time.Instant(0L), new org.joda.time.Instant(Long.MAX_VALUE))), (Matcher)Matchers.equalTo((Object)Window.apply((Instant)Instant.EPOCH, (Instant)Instant.ofEpochMilli(Long.MAX_VALUE))));
        Assert.assertThat((Object)TranslatorUtils.boundedWindowToGearpumpWindow((BoundedWindow)new IntervalWindow(new org.joda.time.Instant(Long.MIN_VALUE), new org.joda.time.Instant(Long.MAX_VALUE))), (Matcher)Matchers.equalTo((Object)Window.apply((Instant)Instant.ofEpochMilli(Long.MIN_VALUE), (Instant)Instant.ofEpochMilli(Long.MAX_VALUE))));
        GlobalWindow globalWindow = GlobalWindow.INSTANCE;
        Assert.assertThat((Object)TranslatorUtils.boundedWindowToGearpumpWindow((BoundedWindow)globalWindow), (Matcher)Matchers.equalTo((Object)Window.apply((Instant)Instant.ofEpochMilli(BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis()), (Instant)Instant.ofEpochMilli(globalWindow.maxTimestamp().getMillis() + 1L))));
    }
}

