/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.beam.runners.gearpump.translators.WindowAssignTranslator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;

public class WindowAssignTranslatorTest {
    @Test
    public void testAssignWindowsWithSlidingWindow() {
        SlidingWindows slidingWindows = SlidingWindows.of((Duration)Duration.millis((long)10L)).every(Duration.millis((long)5L));
        WindowAssignTranslator.AssignWindows assignWindows = new WindowAssignTranslator.AssignWindows((WindowFn)slidingWindows);
        String value = "v1";
        Instant timestamp = new Instant(1L);
        WindowedValue windowedValue = WindowedValue.timestampedValueInGlobalWindow((Object)value, (Instant)timestamp);
        ArrayList<WindowedValue> expected = new ArrayList<WindowedValue>();
        expected.add(WindowedValue.of((Object)value, (Instant)timestamp, (BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(10L)), (PaneInfo)PaneInfo.NO_FIRING));
        expected.add(WindowedValue.of((Object)value, (Instant)timestamp, (BoundedWindow)new IntervalWindow(new Instant(-5L), new Instant(5L)), (PaneInfo)PaneInfo.NO_FIRING));
        Iterator result = assignWindows.flatMap(windowedValue);
        Assert.assertThat(expected, (Matcher)Matchers.equalTo((Object)Lists.newArrayList((Iterator)result)));
    }

    @Test
    public void testAssignWindowsWithSessions() {
        Sessions slidingWindows = Sessions.withGapDuration((Duration)Duration.millis((long)10L));
        WindowAssignTranslator.AssignWindows assignWindows = new WindowAssignTranslator.AssignWindows((WindowFn)slidingWindows);
        String value = "v1";
        Instant timestamp = new Instant(1L);
        WindowedValue windowedValue = WindowedValue.timestampedValueInGlobalWindow((Object)value, (Instant)timestamp);
        ArrayList<WindowedValue> expected = new ArrayList<WindowedValue>();
        expected.add(WindowedValue.of((Object)value, (Instant)timestamp, (BoundedWindow)new IntervalWindow(new Instant(1L), new Instant(11L)), (PaneInfo)PaneInfo.NO_FIRING));
        Iterator result = assignWindows.flatMap(windowedValue);
        Assert.assertThat(expected, (Matcher)Matchers.equalTo((Object)Lists.newArrayList((Iterator)result)));
    }

    @Test
    public void testAssignWindowsGlobal() {
        GlobalWindows slidingWindows = new GlobalWindows();
        WindowAssignTranslator.AssignWindows assignWindows = new WindowAssignTranslator.AssignWindows((WindowFn)slidingWindows);
        String value = "v1";
        Instant timestamp = new Instant(1L);
        WindowedValue windowedValue = WindowedValue.timestampedValueInGlobalWindow((Object)value, (Instant)timestamp);
        ArrayList<WindowedValue> expected = new ArrayList<WindowedValue>();
        expected.add(WindowedValue.timestampedValueInGlobalWindow((Object)value, (Instant)timestamp));
        Iterator result = assignWindows.flatMap(windowedValue);
        Assert.assertThat(expected, (Matcher)Matchers.equalTo((Object)Lists.newArrayList((Iterator)result)));
    }
}

