/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.streaming.dsl.javaapi.JavaStream;
import io.gearpump.streaming.source.DataSource;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.runners.gearpump.translators.ReadUnboundedTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.runners.gearpump.translators.io.UnboundedSourceWrapper;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.values.PValue;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ReadUnboundedTranslatorTest {
    @Test
    public void testTranslate() {
        ReadUnboundedTranslator translator = new ReadUnboundedTranslator();
        GearpumpPipelineOptions options = (GearpumpPipelineOptions)PipelineOptionsFactory.create().as(GearpumpPipelineOptions.class);
        Read.Unbounded transform = (Read.Unbounded)Mockito.mock(Read.Unbounded.class);
        UnboundedSource source = (UnboundedSource)Mockito.mock(UnboundedSource.class);
        Mockito.when((Object)transform.getSource()).thenReturn((Object)source);
        TranslationContext translationContext = (TranslationContext)Mockito.mock(TranslationContext.class);
        Mockito.when((Object)translationContext.getPipelineOptions()).thenReturn((Object)options);
        JavaStream stream = (JavaStream)Mockito.mock(JavaStream.class);
        PValue mockOutput = (PValue)Mockito.mock(PValue.class);
        Mockito.when((Object)translationContext.getOutput()).thenReturn((Object)mockOutput);
        Mockito.when((Object)translationContext.getSourceStream((DataSource)Matchers.any(DataSource.class))).thenReturn((Object)stream);
        translator.translate(transform, translationContext);
        ((TranslationContext)Mockito.verify((Object)translationContext)).getSourceStream((DataSource)Matchers.argThat((ArgumentMatcher)new UnboundedSourceWrapperMatcher()));
        ((TranslationContext)Mockito.verify((Object)translationContext)).setOutputStream(mockOutput, stream);
    }

    private static class UnboundedSourceWrapperMatcher
    implements ArgumentMatcher<DataSource> {
        private UnboundedSourceWrapperMatcher() {
        }

        public boolean matches(DataSource o) {
            return o instanceof UnboundedSourceWrapper;
        }
    }
}

