/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.streaming.dsl.javaapi.JavaStream;
import io.gearpump.streaming.source.DataSource;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.runners.gearpump.translators.ReadBoundedTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.runners.gearpump.translators.io.BoundedSourceWrapper;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.values.PValue;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ReadBoundedTranslatorTest {
    @Test
    public void testTranslate() {
        ReadBoundedTranslator translator = new ReadBoundedTranslator();
        GearpumpPipelineOptions options = (GearpumpPipelineOptions)PipelineOptionsFactory.create().as(GearpumpPipelineOptions.class);
        Read.Bounded transform = (Read.Bounded)Mockito.mock(Read.Bounded.class);
        BoundedSource source = (BoundedSource)Mockito.mock(BoundedSource.class);
        Mockito.when((Object)transform.getSource()).thenReturn((Object)source);
        TranslationContext translationContext = (TranslationContext)Mockito.mock(TranslationContext.class);
        Mockito.when((Object)translationContext.getPipelineOptions()).thenReturn((Object)options);
        JavaStream stream = (JavaStream)Mockito.mock(JavaStream.class);
        PValue mockOutput = (PValue)Mockito.mock(PValue.class);
        Mockito.when((Object)translationContext.getOutput()).thenReturn((Object)mockOutput);
        Mockito.when((Object)translationContext.getSourceStream((DataSource)Matchers.any(DataSource.class))).thenReturn((Object)stream);
        translator.translate(transform, translationContext);
        ((TranslationContext)Mockito.verify((Object)translationContext)).getSourceStream((DataSource)Matchers.argThat((ArgumentMatcher)new BoundedSourceWrapperMatcher()));
        ((TranslationContext)Mockito.verify((Object)translationContext)).setOutputStream(mockOutput, stream);
    }

    private static class BoundedSourceWrapperMatcher
    implements ArgumentMatcher<DataSource> {
        private BoundedSourceWrapperMatcher() {
        }

        public boolean matches(DataSource o) {
            return o instanceof BoundedSourceWrapper;
        }
    }
}

