/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.streaming.dsl.window.api.WindowFunction;
import io.gearpump.streaming.dsl.window.impl.Window;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beam.runners.gearpump.translators.GroupByKeyTranslator;
import org.apache.beam.runners.gearpump.translators.utils.TranslatorUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByKeyTranslatorTest {
    @Parameterized.Parameter(value=0)
    public TimestampCombiner timestampCombiner;

    @Test
    public void testGearpumpWindowFn() {
        GroupByKeyTranslator.GearpumpWindowFn windowFn = new GroupByKeyTranslator.GearpumpWindowFn(true);
        final ArrayList windows = Lists.newArrayList((Object[])new BoundedWindow[]{new IntervalWindow(new org.joda.time.Instant(0L), new org.joda.time.Instant(10L)), new IntervalWindow(new org.joda.time.Instant(5L), new org.joda.time.Instant(15L))});
        WindowFunction.Context<WindowedValue<String>> context = new WindowFunction.Context<WindowedValue<String>>(){

            public Instant timestamp() {
                return Instant.EPOCH;
            }

            public WindowedValue<String> element() {
                return WindowedValue.of((Object)"v1", (org.joda.time.Instant)new org.joda.time.Instant(6L), (Collection)windows, (PaneInfo)PaneInfo.NO_FIRING);
            }
        };
        Window[] result = windowFn.apply((WindowFunction.Context)context);
        ArrayList expected = Lists.newArrayList();
        for (BoundedWindow w : windows) {
            expected.add(TranslatorUtils.boundedWindowToGearpumpWindow((BoundedWindow)w));
        }
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)expected.toArray()));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<TimestampCombiner> data() {
        return ImmutableList.of((Object)TimestampCombiner.EARLIEST, (Object)TimestampCombiner.LATEST, (Object)TimestampCombiner.END_OF_WINDOW);
    }

    @Test
    public void testKeyedByTimestamp() {
        Sessions slidingWindows = Sessions.withGapDuration((Duration)Duration.millis((long)10L));
        IntervalWindow window = new IntervalWindow(new org.joda.time.Instant(0L), new org.joda.time.Instant(10L));
        GroupByKeyTranslator.KeyedByTimestamp keyedByTimestamp = new GroupByKeyTranslator.KeyedByTimestamp((WindowFn)slidingWindows, this.timestampCombiner);
        WindowedValue value = WindowedValue.of((Object)KV.of((Object)"key", (Object)"val"), (org.joda.time.Instant)org.joda.time.Instant.now(), (BoundedWindow)window, (PaneInfo)PaneInfo.NO_FIRING);
        KV result = keyedByTimestamp.map(value);
        org.joda.time.Instant time = this.timestampCombiner.assign((BoundedWindow)window, slidingWindows.getOutputTime(value.getTimestamp(), (BoundedWindow)window));
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)KV.of((Object)time, (Object)value)));
    }

    @Test
    public void testMerge() {
        Sessions slidingWindows = Sessions.withGapDuration((Duration)Duration.millis((long)10L));
        GroupByKeyTranslator.Merge merge = new GroupByKeyTranslator.Merge((WindowFn)slidingWindows, this.timestampCombiner);
        org.joda.time.Instant key1 = new org.joda.time.Instant(5L);
        WindowedValue value1 = WindowedValue.of((Object)KV.of((Object)"key1", (Object)"value1"), (org.joda.time.Instant)key1, (BoundedWindow)new IntervalWindow(new org.joda.time.Instant(5L), new org.joda.time.Instant(10L)), (PaneInfo)PaneInfo.NO_FIRING);
        org.joda.time.Instant key2 = new org.joda.time.Instant(10L);
        WindowedValue value2 = WindowedValue.of((Object)KV.of((Object)"key2", (Object)"value2"), (org.joda.time.Instant)key2, (BoundedWindow)new IntervalWindow(new org.joda.time.Instant(9L), new org.joda.time.Instant(14L)), (PaneInfo)PaneInfo.NO_FIRING);
        KV result1 = merge.fold(KV.of(null, null), KV.of((Object)key1, (Object)value1));
        Assert.assertThat((Object)((org.joda.time.Instant)result1.getKey()), (Matcher)Matchers.equalTo((Object)key1));
        Assert.assertThat((Object)((List)((KV)((WindowedValue)result1.getValue()).getValue()).getValue()), (Matcher)Matchers.equalTo((Object)Lists.newArrayList((Object[])new String[]{"value1"})));
        KV result2 = merge.fold(result1, KV.of((Object)key2, (Object)value2));
        Assert.assertThat((Object)((org.joda.time.Instant)result2.getKey()), (Matcher)Matchers.equalTo((Object)this.timestampCombiner.combine(new org.joda.time.Instant[]{key1, key2})));
        Collection resultWindows = ((WindowedValue)result2.getValue()).getWindows();
        Assert.assertThat((Object)resultWindows.size(), (Matcher)Matchers.equalTo((Object)1));
        IntervalWindow expectedWindow = new IntervalWindow(new org.joda.time.Instant(5L), new org.joda.time.Instant(14L));
        Assert.assertThat((Object)resultWindows.toArray()[0], (Matcher)Matchers.equalTo((Object)expectedWindow));
        Assert.assertThat((Object)((List)((KV)((WindowedValue)result2.getValue()).getValue()).getValue()), (Matcher)Matchers.equalTo((Object)Lists.newArrayList((Object[])new String[]{"value1", "value2"})));
    }
}

