/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.gearpump.translators;

import io.gearpump.streaming.dsl.api.functions.MapFunction;
import io.gearpump.streaming.dsl.javaapi.JavaStream;
import io.gearpump.streaming.source.DataSource;
import java.util.Collections;
import java.util.HashMap;
import org.apache.beam.runners.gearpump.GearpumpPipelineOptions;
import org.apache.beam.runners.gearpump.translators.FlattenPCollectionsTranslator;
import org.apache.beam.runners.gearpump.translators.TranslationContext;
import org.apache.beam.runners.gearpump.translators.io.UnboundedSourceWrapper;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FlattenPCollectionsTranslatorTest {
    private FlattenPCollectionsTranslator translator = new FlattenPCollectionsTranslator();
    private Flatten.PCollections transform = (Flatten.PCollections)Mockito.mock(Flatten.PCollections.class);

    @Test
    public void testTranslateWithEmptyCollection() {
        PCollection mockOutput = (PCollection)Mockito.mock(PCollection.class);
        TranslationContext translationContext = (TranslationContext)Mockito.mock(TranslationContext.class);
        Mockito.when((Object)translationContext.getInputs()).thenReturn((Object)Collections.EMPTY_MAP);
        Mockito.when((Object)translationContext.getOutput()).thenReturn((Object)mockOutput);
        Mockito.when((Object)translationContext.getPipelineOptions()).thenReturn((Object)((GearpumpPipelineOptions)PipelineOptionsFactory.as(GearpumpPipelineOptions.class)));
        this.translator.translate(this.transform, translationContext);
        ((TranslationContext)Mockito.verify((Object)translationContext)).getSourceStream((DataSource)Matchers.argThat((ArgumentMatcher)new UnboundedSourceWrapperMatcher()));
    }

    @Test
    public void testTranslateWithOneCollection() {
        JavaStream javaStream = (JavaStream)Mockito.mock(JavaStream.class);
        TranslationContext translationContext = (TranslationContext)Mockito.mock(TranslationContext.class);
        HashMap<TupleTag, PCollection> inputs = new HashMap<TupleTag, PCollection>();
        TupleTag tag = (TupleTag)Mockito.mock(TupleTag.class);
        PCollection mockCollection = (PCollection)Mockito.mock(PCollection.class);
        inputs.put(tag, mockCollection);
        Mockito.when((Object)translationContext.getInputs()).thenReturn(inputs);
        Mockito.when((Object)translationContext.getInputStream((PValue)mockCollection)).thenReturn((Object)javaStream);
        PValue mockOutput = (PValue)Mockito.mock(PValue.class);
        Mockito.when((Object)translationContext.getOutput()).thenReturn((Object)mockOutput);
        this.translator.translate(this.transform, translationContext);
        ((TranslationContext)Mockito.verify((Object)translationContext, (VerificationMode)Mockito.times((int)1))).setOutputStream(mockOutput, javaStream);
    }

    @Test
    public void testWithMoreThanOneCollections() {
        String transformName = "transform";
        Mockito.when((Object)this.transform.getName()).thenReturn((Object)transformName);
        JavaStream javaStream1 = (JavaStream)Mockito.mock(JavaStream.class);
        JavaStream javaStream2 = (JavaStream)Mockito.mock(JavaStream.class);
        JavaStream mergedStream = (JavaStream)Mockito.mock(JavaStream.class);
        TranslationContext translationContext = (TranslationContext)Mockito.mock(TranslationContext.class);
        HashMap<TupleTag, PCollection> inputs = new HashMap<TupleTag, PCollection>();
        TupleTag tag1 = (TupleTag)Mockito.mock(TupleTag.class);
        PCollection mockCollection1 = (PCollection)Mockito.mock(PCollection.class);
        inputs.put(tag1, mockCollection1);
        TupleTag tag2 = (TupleTag)Mockito.mock(TupleTag.class);
        PCollection mockCollection2 = (PCollection)Mockito.mock(PCollection.class);
        inputs.put(tag2, mockCollection2);
        PCollection output = (PCollection)Mockito.mock(PCollection.class);
        Mockito.when((Object)translationContext.getInputs()).thenReturn(inputs);
        Mockito.when((Object)translationContext.getInputStream((PValue)mockCollection1)).thenReturn((Object)javaStream1);
        Mockito.when((Object)translationContext.getInputStream((PValue)mockCollection2)).thenReturn((Object)javaStream2);
        Mockito.when((Object)javaStream1.merge(javaStream2, 1, transformName)).thenReturn((Object)mergedStream);
        Mockito.when((Object)javaStream2.merge(javaStream1, 1, transformName)).thenReturn((Object)mergedStream);
        Mockito.when((Object)translationContext.getOutput()).thenReturn((Object)output);
        this.translator.translate(this.transform, translationContext);
        ((TranslationContext)Mockito.verify((Object)translationContext)).setOutputStream((PValue)output, mergedStream);
    }

    @Test
    public void testWithDuplicatedCollections() {
        String transformName = "transform";
        Mockito.when((Object)this.transform.getName()).thenReturn((Object)transformName);
        JavaStream javaStream1 = (JavaStream)Mockito.mock(JavaStream.class);
        TranslationContext translationContext = (TranslationContext)Mockito.mock(TranslationContext.class);
        HashMap<TupleTag, PCollection> inputs = new HashMap<TupleTag, PCollection>();
        TupleTag tag1 = (TupleTag)Mockito.mock(TupleTag.class);
        PCollection mockCollection1 = (PCollection)Mockito.mock(PCollection.class);
        inputs.put(tag1, mockCollection1);
        TupleTag tag2 = (TupleTag)Mockito.mock(TupleTag.class);
        inputs.put(tag2, mockCollection1);
        Mockito.when((Object)translationContext.getInputs()).thenReturn(inputs);
        Mockito.when((Object)translationContext.getInputStream((PValue)mockCollection1)).thenReturn((Object)javaStream1);
        Mockito.when((Object)translationContext.getPipelineOptions()).thenReturn((Object)((GearpumpPipelineOptions)PipelineOptionsFactory.as(GearpumpPipelineOptions.class)));
        this.translator.translate(this.transform, translationContext);
        ((JavaStream)Mockito.verify((Object)javaStream1)).map((MapFunction)Mockito.any(MapFunction.class), (String)Mockito.eq((Object)"dummy"));
        ((JavaStream)Mockito.verify((Object)javaStream1)).merge((JavaStream)Mockito.eq(null), Mockito.eq((int)1), (String)Mockito.eq((Object)transformName));
    }

    private static class UnboundedSourceWrapperMatcher
    implements ArgumentMatcher<DataSource> {
        private UnboundedSourceWrapperMatcher() {
        }

        public boolean matches(DataSource o) {
            return o instanceof UnboundedSourceWrapper;
        }
    }
}

